/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graphstream.algorithm.AbstractSpanningTree;
import org.graphstream.algorithm.util.DisjointSets;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class Kruskal
extends AbstractSpanningTree {
    public static final String DEFAULT_WEIGHT_ATTRIBUTE = "weight";
    protected String weightAttribute;
    protected List<Edge> treeEdges;
    protected double treeWeight;

    public Kruskal() {
        this(DEFAULT_WEIGHT_ATTRIBUTE, null);
    }

    public Kruskal(String weightAttribute, String flagAttribute) {
        this(weightAttribute, flagAttribute, true, false);
    }

    public Kruskal(String flagAttribute, Object flagOn, Object flagOff) {
        this(DEFAULT_WEIGHT_ATTRIBUTE, flagAttribute, flagOn, flagOff);
    }

    public Kruskal(String weightAttribute, String flagAttribute, Object flagOn, Object flagOff) {
        super(flagAttribute, flagOn, flagOff);
        this.weightAttribute = weightAttribute;
    }

    public String getWeightAttribute() {
        return this.weightAttribute;
    }

    @Parameter
    public void setWeightAttribute(String newWeightAttribute) {
        this.weightAttribute = newWeightAttribute;
    }

    @Override
    protected void makeTree() {
        if (this.treeEdges == null) {
            this.treeEdges = new LinkedList<Edge>();
        } else {
            this.treeEdges.clear();
        }
        ArrayList sortedEdges = new ArrayList(this.graph.edges().collect(Collectors.toList()));
        Collections.sort(sortedEdges, new EdgeComparator());
        DisjointSets<Node> components = new DisjointSets<Node>(this.graph.getNodeCount());
        for (Node node : this.graph) {
            components.add(node);
        }
        this.treeWeight = 0.0;
        for (Edge edge : sortedEdges) {
            if (!components.union(edge.getNode0(), edge.getNode1())) continue;
            this.treeEdges.add(edge);
            this.edgeOn(edge);
            this.treeWeight += this.getWeight(edge);
            if (this.treeEdges.size() != this.graph.getNodeCount() - 1) continue;
            break;
        }
        sortedEdges.clear();
        components.clear();
    }

    @Override
    public Stream<Edge> getTreeEdgesStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TreeIterator(), 1281), false);
    }

    @Override
    public void clear() {
        super.clear();
        this.treeEdges.clear();
    }

    public double getTreeWeight() {
        return this.treeWeight;
    }

    protected double getWeight(Edge e) {
        if (this.weightAttribute == null) {
            return 1.0;
        }
        double w = e.getNumber(this.weightAttribute);
        if (Double.isNaN(w)) {
            return 1.0;
        }
        return w;
    }

    @Result
    public String defaultResult() {
        StringJoiner sj = new StringJoiner(" | ", "====== Kruskal ====== \n", "");
        this.getTreeEdgesStream().forEach(n -> sj.add(n.getId()));
        return sj.toString();
    }

    protected class TreeIterator
    implements Iterator<Edge> {
        protected Iterator<Edge> it;

        protected TreeIterator() {
            this.it = Kruskal.this.treeEdges.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Edge next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove.");
        }
    }

    protected class EdgeComparator
    implements Comparator<Edge> {
        protected EdgeComparator() {
        }

        @Override
        public int compare(Edge arg0, Edge arg1) {
            double w1;
            double w0 = Kruskal.this.getWeight(arg0);
            if (w0 < (w1 = Kruskal.this.getWeight(arg1))) {
                return -1;
            }
            if (w0 > w1) {
                return 1;
            }
            return 0;
        }
    }
}

