/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.reveallayout;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import per.goweii.reveallayout.R;

public class RevealLayout
extends FrameLayout {
    private View mCheckedView;
    private View mUncheckedView;
    private int mCheckedLayoutId;
    private int mUncheckedLayoutId;
    private boolean mChecked;
    private long mAnimDuration;
    private boolean mCheckWithExpand;
    private boolean mUncheckWithExpand;
    private boolean mAllowRevert;
    private float mCenterX;
    private float mCenterY;
    private float mRevealRadius = 0.0f;
    private final Path mPath = new Path();
    private ValueAnimator mAnimator;
    private TimeInterpolator mInterpolator = null;
    private OnCheckedChangeListener mOnCheckedChangeListener = null;
    private OnAnimStateChangeListener mOnAnimStateChangeListener = null;

    public RevealLayout(Context context) {
        this(context, null);
    }

    public RevealLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RevealLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(attrs);
        this.initView();
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    public void setOnAnimStateChangeListener(OnAnimStateChangeListener onAnimStateChangeListener) {
        this.mOnAnimStateChangeListener = onAnimStateChangeListener;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        if (this.mChecked) {
            this.mCheckedView.bringToFront();
        } else {
            this.mUncheckedView.bringToFront();
        }
    }

    public void toggle() {
        boolean bl = this.mChecked = !this.mChecked;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
        }
        if (this.mAnimator != null) {
            this.mAnimator.reverse();
            if (this.mOnAnimStateChangeListener != null) {
                this.mOnAnimStateChangeListener.onReverse();
            }
        } else {
            this.createRevealAnim();
        }
    }

    public void setAllowRevert(boolean allowRevert) {
        this.mAllowRevert = allowRevert;
    }

    public void setAnimDuration(long animDuration) {
        this.mAnimDuration = animDuration;
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setCheckWithExpand(boolean checkWithExpand) {
        this.mCheckWithExpand = checkWithExpand;
    }

    public void setUncheckWithExpand(boolean uncheckWithExpand) {
        this.mUncheckWithExpand = uncheckWithExpand;
    }

    public void setCheckedView(View checkedView) {
        this.mCheckedView = checkedView;
        this.initView();
    }

    public void setUncheckedView(View uncheckedView) {
        this.mUncheckedView = uncheckedView;
        this.initView();
    }

    public void setCheckedLayoutId(int checkedLayoutId) {
        this.mCheckedLayoutId = checkedLayoutId;
        this.setCheckedView(this.createCheckedView());
    }

    public void setUncheckedLayoutId(int uncheckedLayoutId) {
        this.mUncheckedLayoutId = uncheckedLayoutId;
        this.setUncheckedView(this.createUncheckedView());
    }

    protected void initAttr(AttributeSet attrs) {
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.RevealLayout);
        this.mCheckedLayoutId = array.getResourceId(R.styleable.RevealLayout_rl_checked_layout, 0);
        this.mUncheckedLayoutId = array.getResourceId(R.styleable.RevealLayout_rl_unchecked_layout, 0);
        this.mChecked = array.getBoolean(R.styleable.RevealLayout_rl_checked, false);
        this.mAnimDuration = array.getInteger(R.styleable.RevealLayout_rl_anim_duration, 500);
        this.mCheckWithExpand = array.getBoolean(R.styleable.RevealLayout_rl_check_with_expand, true);
        this.mUncheckWithExpand = array.getBoolean(R.styleable.RevealLayout_rl_uncheck_with_expand, false);
        this.mAllowRevert = array.getBoolean(R.styleable.RevealLayout_rl_allow_revert, false);
        array.recycle();
    }

    protected View createCheckedView() {
        View checkedView = this.mCheckedLayoutId > 0 ? RevealLayout.inflate((Context)this.getContext(), (int)this.mCheckedLayoutId, null) : new View(this.getContext());
        return checkedView;
    }

    protected View createUncheckedView() {
        View uncheckedView = this.mUncheckedLayoutId > 0 ? RevealLayout.inflate((Context)this.getContext(), (int)this.mUncheckedLayoutId, null) : new View(this.getContext());
        return uncheckedView;
    }

    private void initView() {
        this.removeAllViews();
        if (this.mCheckedView == null) {
            this.mCheckedView = this.createCheckedView();
        }
        if (this.mUncheckedView == null) {
            this.mUncheckedView = this.createUncheckedView();
        }
        this.addView(this.mCheckedView, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
        this.addView(this.mUncheckedView, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
        this.setChecked(this.mChecked);
    }

    private FrameLayout.LayoutParams getDefaultLayoutParams() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        return params;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                return this.isValidClick(event.getX(), event.getY());
            }
            case 1: {
                float unX = event.getX();
                float unY = event.getY();
                if (this.isValidClick(unX, unY)) {
                    if (this.mAnimator != null) {
                        if (this.mAllowRevert) {
                            this.toggle();
                            return true;
                        }
                        return false;
                    }
                    this.mRevealRadius = 0.0f;
                    this.mCenterX = unX;
                    this.mCenterY = unY;
                    this.toggle();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isValidClick(float x, float y) {
        return x >= 0.0f && x <= (float)this.getWidth() && y >= 0.0f && y <= (float)this.getHeight();
    }

    private void createRevealAnim() {
        float[] value = this.calculateAnimOfFloat();
        this.mRevealRadius = value[0];
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{value[0], value[1]});
        this.mAnimator.setInterpolator((TimeInterpolator)(this.mInterpolator != null ? this.mInterpolator : new DecelerateInterpolator()));
        this.mAnimator.setDuration(this.mAnimDuration);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                RevealLayout.this.mRevealRadius = ((Float)animation.getAnimatedValue()).floatValue();
                RevealLayout.this.resetPath();
                RevealLayout.this.invalidate();
            }
        });
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                RevealLayout.this.resetPath();
                RevealLayout.this.bringCurrentViewToFront();
                if (RevealLayout.this.mOnAnimStateChangeListener != null) {
                    RevealLayout.this.mOnAnimStateChangeListener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                RevealLayout.this.mAnimator = null;
                RevealLayout.this.bringCurrentViewToFront();
                if (RevealLayout.this.mOnAnimStateChangeListener != null) {
                    RevealLayout.this.mOnAnimStateChangeListener.onEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
                RevealLayout.this.mAnimator = null;
                if (RevealLayout.this.mOnAnimStateChangeListener != null) {
                    RevealLayout.this.mOnAnimStateChangeListener.onCancel();
                }
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mAnimator.start();
    }

    private float[] calculateAnimOfFloat() {
        float toValue;
        float fromValue;
        float maxRadius = this.calculateMaxRadius();
        if (this.mChecked) {
            if (this.mCheckWithExpand) {
                fromValue = 0.0f;
                toValue = maxRadius;
            } else {
                fromValue = maxRadius;
                toValue = 0.0f;
            }
        } else if (this.mUncheckWithExpand) {
            fromValue = 0.0f;
            toValue = maxRadius;
        } else {
            fromValue = maxRadius;
            toValue = 0.0f;
        }
        return new float[]{fromValue, toValue};
    }

    private void resetPath() {
        this.mPath.reset();
        this.mPath.addCircle(this.mCenterX, this.mCenterY, this.mRevealRadius, Path.Direction.CW);
    }

    private void bringCurrentViewToFront() {
        if (this.mRevealRadius == 0.0f) {
            if (this.mChecked) {
                this.mCheckedView.bringToFront();
            } else {
                this.mUncheckedView.bringToFront();
            }
        }
    }

    private float calculateMaxRadius() {
        float x = Math.max(this.mCenterX, (float)this.getMeasuredWidth() - this.mCenterX);
        float y = Math.max(this.mCenterY, (float)this.getMeasuredHeight() - this.mCenterY);
        return (float)Math.hypot(x, y);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (this.mAnimator == null) {
            return super.drawChild(canvas, child, drawingTime);
        }
        if (this.isBottomChild(child)) {
            return super.drawChild(canvas, child, drawingTime);
        }
        canvas.save();
        canvas.clipPath(this.mPath);
        boolean drawChild = super.drawChild(canvas, child, drawingTime);
        canvas.restore();
        return drawChild;
    }

    private boolean isBottomChild(View child) {
        return this.getChildAt(0) == child;
    }

    public static interface OnAnimStateChangeListener {
        public void onStart();

        public void onReverse();

        public void onEnd();

        public void onCancel();
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RevealLayout var1, boolean var2);
    }
}

