/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.burred;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import per.goweii.burred.FastBlur;
import per.goweii.burred.GaussianBlur;
import per.goweii.burred.IBlur;
import per.goweii.burred.Utils;

public final class Blurred {
    private static IBlur sBlur;
    private static ExecutorService sExecutor;
    private float mPercent = 0.0f;
    private float mRadius = 0.0f;
    private float mScale = 1.0f;
    private boolean mKeepSize = false;
    private boolean mRecycleOriginal = false;
    private int mBackgroundColor = 0;
    private int mForegroundColor = 0;
    private Bitmap mOriginalBitmap = null;
    private View mViewFrom = null;
    private ImageView mViewInto = null;
    private SnapshotInterceptor mSnapshotInterceptor = null;
    private Listener mListener = null;
    private Callback mCallback = null;
    private Handler mCallbackHandler = null;
    private ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = null;

    public static void init(Context context) {
        if (sBlur == null) {
            sBlur = Build.VERSION.SDK_INT >= 17 ? GaussianBlur.get(context) : FastBlur.get();
        }
    }

    public static void realTimeMode(boolean realTimeMode) {
        IBlur iBlur = Blurred.requireBlur();
        if (iBlur instanceof GaussianBlur) {
            GaussianBlur gaussianBlur = (GaussianBlur)sBlur;
            gaussianBlur.realTimeMode(realTimeMode);
        }
    }

    public static void recycle() {
        if (sBlur != null) {
            sBlur.recycle();
            sBlur = null;
        }
        if (sExecutor != null) {
            if (!sExecutor.isShutdown()) {
                sExecutor.shutdown();
            }
            sExecutor = null;
        }
    }

    private static IBlur requireBlur() {
        return Utils.requireNonNull(sBlur, "Blurred\u672a\u521d\u59cb\u5316");
    }

    private static ExecutorService requireExecutor() {
        if (sExecutor == null || sExecutor.isShutdown()) {
            sExecutor = Executors.newSingleThreadExecutor();
        }
        return sExecutor;
    }

    public static Blurred with(Bitmap original) {
        return new Blurred().bitmap(original);
    }

    public static Blurred with(View view) {
        return new Blurred().view(view);
    }

    public void reset() {
        this.mPercent = 0.0f;
        this.mRadius = 0.0f;
        this.mScale = 1.0f;
        this.mKeepSize = false;
        this.mRecycleOriginal = false;
        this.mOriginalBitmap = null;
        if (this.mViewFrom != null) {
            if (this.mOnPreDrawListener != null) {
                this.mViewFrom.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
                this.mOnPreDrawListener = null;
            }
            this.mViewFrom = null;
        }
        this.mViewInto = null;
    }

    public Blurred view(View view) {
        this.reset();
        this.mViewFrom = view;
        return this;
    }

    public Blurred bitmap(Bitmap original) {
        this.reset();
        this.mOriginalBitmap = original;
        return this;
    }

    public Blurred backgroundColor(int color) {
        this.mBackgroundColor = color;
        return this;
    }

    public Blurred foregroundColor(int color) {
        this.mForegroundColor = color;
        return this;
    }

    public Blurred percent(float percent) {
        this.mPercent = percent;
        return this;
    }

    public Blurred radius(float radius) {
        this.mRadius = radius;
        return this;
    }

    public Blurred scale(float scale) {
        this.mScale = scale;
        return this;
    }

    public Blurred keepSize(boolean keepSize) {
        this.mKeepSize = keepSize;
        return this;
    }

    public Blurred recycleOriginal(boolean recycleOriginal) {
        this.mRecycleOriginal = recycleOriginal;
        return this;
    }

    public Blurred snapshotInterceptor(SnapshotInterceptor interceptor) {
        this.mSnapshotInterceptor = interceptor;
        return this;
    }

    public Blurred listener(Listener listener) {
        this.mListener = listener;
        return this;
    }

    public Bitmap blur() {
        Bitmap blurredBitmap;
        if (this.mViewFrom == null && this.mOriginalBitmap == null) {
            throw new NullPointerException("\u5f85\u6a21\u7ccaView\u548cBitmap\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (this.mListener != null) {
            this.mListener.begin();
        }
        float scale = this.mScale > 0.0f ? this.mScale : 1.0f;
        float radius = this.mRadius;
        if (this.mPercent > 0.0f) {
            int h;
            int w;
            if (this.mViewFrom != null) {
                w = this.mViewFrom.getWidth();
                h = this.mViewFrom.getHeight();
            } else {
                w = this.mOriginalBitmap.getWidth();
                h = this.mOriginalBitmap.getHeight();
            }
            radius = (float)Math.min(w, h) * this.mPercent;
        }
        if (this.mViewFrom == null) {
            blurredBitmap = Blurred.requireBlur().process(this.mOriginalBitmap, radius, scale, this.mKeepSize, this.mRecycleOriginal);
        } else {
            if (radius > 25.0f) {
                scale /= radius / 25.0f;
                radius = 25.0f;
            }
            if (this.mSnapshotInterceptor != null) {
                Bitmap bitmap = this.mSnapshotInterceptor.snapshot(this.mViewFrom, this.mBackgroundColor, this.mForegroundColor, scale);
                blurredBitmap = Blurred.requireBlur().process(bitmap, radius, 1.0f, this.mKeepSize, this.mRecycleOriginal);
            } else {
                Bitmap bitmap = Utils.snapshot(this.mViewFrom, this.mBackgroundColor, this.mForegroundColor, scale);
                blurredBitmap = Blurred.requireBlur().process(bitmap, radius, 1.0f, this.mKeepSize, this.mRecycleOriginal);
            }
        }
        if (this.mListener != null) {
            this.mListener.end();
        }
        return blurredBitmap;
    }

    public void blur(ImageView into) {
        Utils.requireNonNull(this.mViewFrom, "\u5b9e\u65f6\u9ad8\u65af\u6a21\u7cca\u65f6\u5f85\u6a21\u7ccaView\u4e0d\u80fd\u4e3a\u7a7a");
        Utils.requireNonNull(into, "ImageView\u4e0d\u80fd\u4e3a\u7a7a");
        this.mViewInto = into;
        if (this.mOnPreDrawListener == null) {
            this.mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    Blurred.realTimeMode(true);
                    Blurred.this.keepSize(false);
                    Blurred.this.recycleOriginal(true);
                    if (Blurred.this.mViewInto != null) {
                        Bitmap blur = Blurred.this.blur();
                        Bitmap clip = Utils.clip(blur, Blurred.this.mViewFrom, Blurred.this.mViewInto);
                        blur.recycle();
                        Blurred.this.mViewInto.setImageBitmap(clip);
                    }
                    return true;
                }
            };
        }
        this.mViewFrom.getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
    }

    public void blur(Callback callback) {
        Utils.requireNonNull(callback, "Callback\u4e0d\u80fd\u4e3a\u7a7a");
        this.mCallback = callback;
        this.mCallbackHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Blurred.this.mCallbackHandler = null;
                Blurred.this.mCallback.down((Bitmap)msg.obj);
            }
        };
        Blurred.requireExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = Blurred.this.blur();
                Message msg = Blurred.this.mCallbackHandler.obtainMessage();
                msg.obj = bitmap;
                Blurred.this.mCallbackHandler.sendMessage(msg);
            }
        });
    }

    public static interface Listener {
        public void begin();

        public void end();
    }

    public static interface Callback {
        public void down(Bitmap var1);
    }

    public static interface SnapshotInterceptor {
        public Bitmap snapshot(View var1, int var2, int var3, float var4);
    }
}

