/*
 * Copyright (c) 2017 Gowtham Parimelazhagan.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.gm.repository.http;

import okhttp3.HttpUrl;

/**
 * Author     : Gowtham
 * Email      : goutham.gm11@gmail.com
 * Github     : https://github.com/goutham106
 * Created on : 9/18/17.
 * <p>
 * Retrofit Url interface
 */

public interface BaseUrl {
    /**
     * For BaseUrl in the App can not be determined when the start, you need to request the server interface to dynamically obtain the application scenario
     * Before calling the Retrofit interface, use Okhttp or other means to request the correct BaseUrl and return through this method
     *
     * @return HttpUrl
     */
    HttpUrl url();
}
