/*
 * Decompiled with CFR 0.152.
 */
package com.gm.lifecycle.delegate;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.gm.lifecycle.delegate.FragmentDelegate;
import com.gm.lifecycle.delegate.FragmentDelegateImpl;
import com.gm.lifecycle.delegate.IFragment;
import timber.log.Timber;

public class FragmentLifecycle
extends FragmentManager.FragmentLifecycleCallbacks {
    public void onFragmentAttached(FragmentManager fm, Fragment f, Context context) {
        super.onFragmentAttached(fm, f, context);
        if (f instanceof IFragment && f.getArguments() != null) {
            Timber.i((String)"%s ---> onFragmentAttached", (Object[])new Object[]{f.toString()});
            FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
            if (fragmentDelegate == null || !fragmentDelegate.isAdded()) {
                fragmentDelegate = new FragmentDelegateImpl(fm, f);
                f.getArguments().putParcelable("fragment_delegate", (Parcelable)fragmentDelegate);
            }
            fragmentDelegate.onAttach(context);
        }
    }

    public void onFragmentCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
        super.onFragmentCreated(fm, f, savedInstanceState);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentCreated", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onCreate(savedInstanceState);
        }
    }

    public void onFragmentViewCreated(FragmentManager fm, Fragment f, View v, Bundle savedInstanceState) {
        super.onFragmentViewCreated(fm, f, v, savedInstanceState);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentViewCreated", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onCreateView(v, savedInstanceState);
        }
    }

    public void onFragmentActivityCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
        super.onFragmentActivityCreated(fm, f, savedInstanceState);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentActivityCreated", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onActivityCreate(savedInstanceState);
        }
    }

    public void onFragmentStarted(FragmentManager fm, Fragment f) {
        super.onFragmentStarted(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentStarted", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onStart();
        }
    }

    public void onFragmentResumed(FragmentManager fm, Fragment f) {
        super.onFragmentResumed(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentResumed", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onResume();
        }
    }

    public void onFragmentPaused(FragmentManager fm, Fragment f) {
        super.onFragmentPaused(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentPaused", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onPause();
        }
    }

    public void onFragmentStopped(FragmentManager fm, Fragment f) {
        super.onFragmentStopped(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentStopped", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onStop();
        }
    }

    public void onFragmentSaveInstanceState(FragmentManager fm, Fragment f, Bundle outState) {
        super.onFragmentSaveInstanceState(fm, f, outState);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentSaveInstanceState", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onSaveInstanceState(outState);
        }
    }

    public void onFragmentViewDestroyed(FragmentManager fm, Fragment f) {
        super.onFragmentViewDestroyed(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentViewDestroyed", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onDestroyView();
        }
    }

    public void onFragmentDestroyed(FragmentManager fm, Fragment f) {
        super.onFragmentDestroyed(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentDestroyed", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onDestroy();
        }
    }

    public void onFragmentDetached(FragmentManager fm, Fragment f) {
        super.onFragmentDetached(fm, f);
        FragmentDelegate fragmentDelegate = this.fetchFragmentDelegate(f);
        if (fragmentDelegate != null) {
            Timber.i((String)"%s ---> onFragmentDetached", (Object[])new Object[]{f.toString()});
            fragmentDelegate.onDetach();
            f.getArguments().clear();
        }
    }

    private FragmentDelegate fetchFragmentDelegate(Fragment fragment) {
        if (fragment instanceof IFragment && fragment.getArguments() != null) {
            fragment.getArguments().setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            return (FragmentDelegate)fragment.getArguments().getParcelable("fragment_delegate");
        }
        return null;
    }
}

