/*
 * Decompiled with CFR 0.152.
 */
package com.gm.lifecycle;

import android.app.Application;
import android.content.Context;
import com.gm.lifecycle.ConfigLifecycle;
import com.gm.lifecycle.delegate.ActivityLifecycle;
import com.gm.lifecycle.delegate.AppLifecycles;
import com.gm.lifecycle.delegate.ILifecycle;
import com.gm.lifecycle.di.component.DaggerLifecycleComponent;
import com.gm.lifecycle.di.component.LifecycleComponent;
import com.gm.lifecycle.di.module.LifecycleModule;
import com.gm.lifecycle.utils.ManifestLifecycleParser;
import com.gm.lifecycle.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class LifecycleInjector
implements ILifecycle,
AppLifecycles {
    @Inject
    protected ActivityLifecycle mActivityLifecycle;
    private Application mApplication;
    private LifecycleComponent mLifecycleComponent;
    private LifecycleModule mLifecycleModule;
    private List<ConfigLifecycle> mConfigLifecycles;
    private List<AppLifecycles> mAppLifecycles = new ArrayList<AppLifecycles>();
    private List<Application.ActivityLifecycleCallbacks> mActivityLifecycles = new ArrayList<Application.ActivityLifecycleCallbacks>();

    public LifecycleInjector(Context context) {
        this.mConfigLifecycles = new ManifestLifecycleParser(context).parse();
        for (ConfigLifecycle lifecycle : this.mConfigLifecycles) {
            lifecycle.injectAppLifecycle(context, this.mAppLifecycles);
            lifecycle.injectActivityLifecycle(context, this.mActivityLifecycles);
        }
    }

    @Override
    public void attachBaseContext(Context context) {
        for (AppLifecycles lifecycle : this.mAppLifecycles) {
            lifecycle.attachBaseContext(context);
        }
    }

    @Override
    public void onCreate(Application application) {
        this.mApplication = application;
        if (this.mLifecycleModule == null) {
            this.mLifecycleModule = new LifecycleModule(this.mApplication);
        }
        this.mLifecycleComponent = DaggerLifecycleComponent.builder().lifecycleModule(this.mLifecycleModule).build();
        this.mLifecycleComponent.inject(this);
        this.mLifecycleComponent.extras().put(ConfigLifecycle.class.getName(), this.mConfigLifecycles);
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        this.mConfigLifecycles = null;
        for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
            this.mApplication.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
        for (AppLifecycles appLifecycles : this.mAppLifecycles) {
            appLifecycles.onCreate(this.mApplication);
        }
    }

    @Override
    public void onTerminate(Application application) {
        if (this.mActivityLifecycle != null) {
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycle);
        }
        if (this.mActivityLifecycles != null && this.mActivityLifecycles.size() > 0) {
            for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityLifecycles) {
                this.mApplication.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
            }
        }
        if (this.mAppLifecycles != null && this.mAppLifecycles.size() > 0) {
            for (AppLifecycles appLifecycles : this.mAppLifecycles) {
                appLifecycles.onTerminate(this.mApplication);
            }
        }
        this.mLifecycleModule = null;
        this.mLifecycleComponent = null;
        this.mActivityLifecycle = null;
        this.mActivityLifecycles = null;
        this.mAppLifecycles = null;
        this.mApplication = null;
    }

    @Override
    public LifecycleComponent getLifecycleComponent() {
        Preconditions.checkNotNull(this.mLifecycleComponent, "%s cannot be null,first call %s#onCreate(Application) in %s#onCreate()", LifecycleComponent.class.getName(), this.getClass().getName(), this.mApplication.getClass().getName());
        return this.mLifecycleComponent;
    }

    @Override
    public LifecycleModule getLifecycleModule() {
        Preconditions.checkNotNull(this.mLifecycleModule, "%s cannot be null,first call %s#onCreate(Application) in %s#onCreate()", LifecycleModule.class.getName(), this.getClass().getName(), this.mApplication.getClass().getName());
        return this.mLifecycleModule;
    }
}

