/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.adk.tools.mcp.DefaultMcpTransportBuilder;
import com.google.adk.tools.mcp.McpTransportBuilder;
import com.google.adk.tools.mcp.SseServerParameters;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSessionManager {
    private final Object connectionParams;
    private final McpTransportBuilder transportBuilder;
    private static final Logger logger = LoggerFactory.getLogger(McpSessionManager.class);

    public McpSessionManager(Object connectionParams) {
        this(connectionParams, new DefaultMcpTransportBuilder());
    }

    public McpSessionManager(Object connectionParams, McpTransportBuilder transportBuilder) {
        this.connectionParams = connectionParams;
        this.transportBuilder = transportBuilder;
    }

    public McpSyncClient createSession() {
        return McpSessionManager.initializeSession(this.connectionParams, this.transportBuilder);
    }

    public static McpSyncClient initializeSession(Object connectionParams) {
        return McpSessionManager.initializeSession(connectionParams, new DefaultMcpTransportBuilder());
    }

    public static McpSyncClient initializeSession(Object connectionParams, McpTransportBuilder transportBuilder) {
        Duration initializationTimeout = null;
        Duration requestTimeout = null;
        McpClientTransport transport = transportBuilder.build(connectionParams);
        if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParams = (SseServerParameters)connectionParams;
            initializationTimeout = sseServerParams.timeout();
            requestTimeout = sseServerParams.sseReadTimeout();
        }
        McpSyncClient client = McpClient.sync((McpClientTransport)transport).initializationTimeout((Duration)Optional.ofNullable(initializationTimeout).orElse(Duration.ofSeconds(10L))).requestTimeout(Optional.ofNullable(requestTimeout).orElse(Duration.ofSeconds(10L))).capabilities(McpSchema.ClientCapabilities.builder().build()).build();
        McpSchema.InitializeResult initResult = client.initialize();
        logger.debug("Initialize Client Result: {}", (Object)initResult);
        return client;
    }

    public McpAsyncClient createAsyncSession() {
        return McpSessionManager.initializeAsyncSession(this.connectionParams);
    }

    public static McpAsyncClient initializeAsyncSession(Object connectionParams) {
        return McpSessionManager.initializeAsyncSession(connectionParams, new DefaultMcpTransportBuilder());
    }

    public static McpAsyncClient initializeAsyncSession(Object connectionParams, McpTransportBuilder transportBuilder) {
        Duration initializationTimeout = null;
        Duration requestTimeout = null;
        McpClientTransport transport = transportBuilder.build(connectionParams);
        if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParams = (SseServerParameters)connectionParams;
            initializationTimeout = sseServerParams.timeout();
            requestTimeout = sseServerParams.sseReadTimeout();
        }
        return McpClient.async((McpClientTransport)transport).initializationTimeout(initializationTimeout == null ? Duration.ofSeconds(10L) : initializationTimeout).requestTimeout(requestTimeout == null ? Duration.ofSeconds(10L) : requestTimeout).capabilities(McpSchema.ClientCapabilities.builder().build()).build();
    }
}

