/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.google.adk.agents.InvocationContext;
import com.google.adk.codeexecutors.BaseCodeExecutor;
import com.google.adk.codeexecutors.CodeExecutionUtils;
import com.google.adk.models.LlmRequest;
import com.google.adk.utils.ModelNameUtils;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.ToolCodeExecution;
import java.util.List;

public class BuiltInCodeExecutor
extends BaseCodeExecutor {
    @Override
    public CodeExecutionUtils.CodeExecutionResult executeCode(InvocationContext invocationContext, CodeExecutionUtils.CodeExecutionInput codeExecutionInput) {
        throw new UnsupportedOperationException("Code execution is not supported for built-in code executor.");
    }

    public void processLlmRequest(LlmRequest.Builder llmRequestBuilder) {
        LlmRequest llmRequest = llmRequestBuilder.build();
        if (ModelNameUtils.isGemini2Model(llmRequest.model().orElse(null))) {
            GenerateContentConfig.Builder configBuilder = llmRequest.config().map(c -> c.toBuilder()).orElse(GenerateContentConfig.builder());
            ImmutableList.Builder toolsBuilder = ImmutableList.builder().addAll((Iterable)configBuilder.build().tools().orElse(ImmutableList.of()));
            toolsBuilder.add((Object)Tool.builder().codeExecution(ToolCodeExecution.builder().build()).build());
            configBuilder.tools((List)toolsBuilder.build());
            llmRequestBuilder.config(configBuilder.build());
            return;
        }
        throw new IllegalArgumentException("Gemini code execution tool is not supported for model " + llmRequest.model().orElse(""));
    }
}

