/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.maven;

import com.google.adk.maven.AgentLoader;
import com.google.adk.maven.web.AdkWebServer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

@Mojo(name="web", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class WebMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="agents")
    private String agents;
    @Parameter(property="port", defaultValue="8000")
    private int port;
    @Parameter(property="host", defaultValue="localhost")
    private String host;
    @Parameter(property="hotReloading", defaultValue="true")
    private boolean hotReloading;
    private ConfigurableApplicationContext applicationContext;
    private URLClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting Google ADK Web Server...");
        this.getLog().info((CharSequence)("Plugin version: " + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion()));
        this.validateParameters();
        this.logConfiguration();
        try {
            this.projectClassLoader = this.createProjectClassLoader();
            Thread.currentThread().setContextClassLoader(this.projectClassLoader);
            this.getLog().info((CharSequence)("Loading agent loader: " + this.agents));
            AgentLoader provider = this.loadAgentProvider();
            this.setupSystemProperties();
            SpringApplication app = new SpringApplication(new Class[]{AdkWebServer.class});
            app.addInitializers(new ApplicationContextInitializer[]{ctx -> ctx.getBeanFactory().registerSingleton("agentLoader", (Object)provider)});
            this.getLog().info((CharSequence)"Starting Spring Boot application...");
            this.applicationContext = app.run(new String[0]);
            this.getLog().info((CharSequence)"\ud83c\udf89 ADK Web Server started successfully!");
            this.getLog().info((CharSequence)("\ud83c\udf10 Web UI available at: http://" + this.host + ":" + this.port));
            this.getLog().info((CharSequence)"\u23f9\ufe0f  Press Ctrl+C to stop the server...");
            this.getLog().info((CharSequence)"");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.getLog().info((CharSequence)"Shutting down ADK Web Server...");
                this.cleanupResources();
            }));
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            this.getLog().info((CharSequence)"Server interrupted, shutting down...");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.cleanupResources();
            throw new MojoExecutionException("Failed to start ADK Web Server", e);
        }
    }

    private void validateParameters() throws MojoFailureException {
        if (this.agents == null || this.agents.trim().isEmpty()) {
            throw new MojoFailureException("agents parameter is required. Usage: mvn google-adk:web -Dagents=com.example.MyProvider.INSTANCE");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new MojoFailureException("Port must be between 1 and 65535, got: " + this.port);
        }
    }

    private void logConfiguration() {
        this.getLog().info((CharSequence)"Configuration:");
        this.getLog().info((CharSequence)("  Agent Provider: " + this.agents));
        this.getLog().info((CharSequence)("  Server Host: " + this.host));
        this.getLog().info((CharSequence)("  Server Port: " + this.port));
        this.getLog().info((CharSequence)("  Hot Reloading: " + this.hotReloading));
    }

    private void setupSystemProperties() {
        System.setProperty("server.address", this.host);
        System.setProperty("server.port", String.valueOf(this.port));
        System.setProperty("adk.agent.hotReloadingEnabled", String.valueOf(this.hotReloading));
    }

    private URLClassLoader createProjectClassLoader() throws MojoExecutionException {
        try {
            ArrayList classpathElements = new ArrayList();
            classpathElements.addAll(this.project.getCompileClasspathElements());
            classpathElements.addAll(this.project.getRuntimeClasspathElements());
            ArrayList<URL> classpathUrls = new ArrayList<URL>();
            for (String element : classpathElements) {
                try {
                    classpathUrls.add(new URL("file:" + element + (element.endsWith(".jar") ? "" : "/")));
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Skipping invalid classpath element: " + element));
                }
            }
            return new URLClassLoader((URL[])classpathUrls.toArray(URL[]::new), Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to resolve project dependencies", (Exception)((Object)e));
        }
    }

    private AgentLoader loadAgentProvider() throws MojoExecutionException {
        AgentLoader provider;
        if (this.agents.contains(".") && (provider = this.tryLoadFromStaticField()) != null) {
            return provider;
        }
        return this.tryLoadFromConstructor();
    }

    private AgentLoader tryLoadFromStaticField() throws MojoExecutionException {
        int lastDotIndex = this.agents.lastIndexOf(46);
        String className = this.agents.substring(0, lastDotIndex);
        String fieldName = this.agents.substring(lastDotIndex + 1);
        try {
            Class<?> providerClass = this.projectClassLoader.loadClass(className);
            Field field = providerClass.getField(fieldName);
            Object instance = field.get(null);
            if (!(instance instanceof AgentLoader)) {
                throw new MojoExecutionException("Field " + fieldName + " in class " + className + " is not an instance of AgentLoader");
            }
            return (AgentLoader)instance;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Cannot access field " + fieldName + " in class " + className, (Exception)e);
        }
    }

    private AgentLoader tryLoadFromConstructor() throws MojoExecutionException {
        try {
            Class<?> providerClass = this.projectClassLoader.loadClass(this.agents);
            Object instance = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof AgentLoader)) {
                throw new MojoExecutionException("Class " + this.agents + " does not implement AgentLoader");
            }
            return (AgentLoader)instance;
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("AgentLoader class not found: " + this.agents + ". Make sure the class is in your project's classpath.", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to instantiate " + this.agents + ". Make sure it has a public default constructor or use the field syntax: com.example.MyProvider.INSTANCE", e);
        }
    }

    private void cleanupResources() {
        this.getLog().debug((CharSequence)"Cleaning up resources...");
        if (this.applicationContext != null) {
            try {
                this.applicationContext.close();
                this.getLog().debug((CharSequence)"Application context closed");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Error closing application context", (Throwable)e);
            }
        }
        if (this.projectClassLoader != null) {
            try {
                this.projectClassLoader.close();
                this.getLog().debug((CharSequence)"Project classloader closed");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error closing project classloader", (Throwable)e);
            }
        }
        this.clearSystemProperties();
        this.getLog().info((CharSequence)"Resource cleanup completed");
    }

    private void clearSystemProperties() {
        try {
            System.clearProperty("server.address");
            System.clearProperty("server.port");
            System.clearProperty("adk.agent.hotReloadingEnabled");
            System.clearProperty("adk.agents.source-dir");
            System.clearProperty("spring.autoconfigure.exclude");
            this.getLog().debug((CharSequence)"System properties cleared");
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Error clearing system properties", (Throwable)e);
        }
    }
}

