/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models.langchain4j;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.models.BaseLlm;
import com.google.adk.models.BaseLlmConnection;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionCallingConfigMode;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import com.google.genai.types.ToolConfig;
import com.google.genai.types.Type;
import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.data.video.Video;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@Experimental
public class LangChain4j
extends BaseLlm {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ChatModel chatModel;
    private final StreamingChatModel streamingChatModel;
    private final ObjectMapper objectMapper;

    public LangChain4j(ChatModel chatModel) {
        super(Objects.requireNonNull(chatModel.defaultRequestParameters().modelName(), "chat model name cannot be null"));
        this.chatModel = Objects.requireNonNull(chatModel, "chatModel cannot be null");
        this.streamingChatModel = null;
        this.objectMapper = new ObjectMapper();
    }

    public LangChain4j(ChatModel chatModel, String modelName) {
        super(Objects.requireNonNull(modelName, "chat model name cannot be null"));
        this.chatModel = Objects.requireNonNull(chatModel, "chatModel cannot be null");
        this.streamingChatModel = null;
        this.objectMapper = new ObjectMapper();
    }

    public LangChain4j(StreamingChatModel streamingChatModel) {
        super(Objects.requireNonNull(streamingChatModel.defaultRequestParameters().modelName(), "streaming chat model name cannot be null"));
        this.chatModel = null;
        this.streamingChatModel = Objects.requireNonNull(streamingChatModel, "streamingChatModel cannot be null");
        this.objectMapper = new ObjectMapper();
    }

    public LangChain4j(StreamingChatModel streamingChatModel, String modelName) {
        super(Objects.requireNonNull(modelName, "streaming chat model name cannot be null"));
        this.chatModel = null;
        this.streamingChatModel = Objects.requireNonNull(streamingChatModel, "streamingChatModel cannot be null");
        this.objectMapper = new ObjectMapper();
    }

    public LangChain4j(ChatModel chatModel, StreamingChatModel streamingChatModel, String modelName) {
        super(Objects.requireNonNull(modelName, "model name cannot be null"));
        this.chatModel = Objects.requireNonNull(chatModel, "chatModel cannot be null");
        this.streamingChatModel = Objects.requireNonNull(streamingChatModel, "streamingChatModel cannot be null");
        this.objectMapper = new ObjectMapper();
    }

    public Flowable<LlmResponse> generateContent(LlmRequest llmRequest, boolean stream) {
        if (stream) {
            if (this.streamingChatModel == null) {
                return Flowable.error((Throwable)new IllegalStateException("StreamingChatModel is not configured"));
            }
            ChatRequest chatRequest = this.toChatRequest(llmRequest);
            return Flowable.create(emitter -> this.streamingChatModel.chat(chatRequest, new StreamingChatResponseHandler(){

                public void onPartialResponse(String s) {
                    emitter.onNext((Object)LlmResponse.builder().content(Content.fromParts((Part[])new Part[]{Part.fromText((String)s)})).build());
                }

                public void onCompleteResponse(ChatResponse chatResponse) {
                    if (chatResponse.aiMessage().hasToolExecutionRequests()) {
                        AiMessage aiMessage = chatResponse.aiMessage();
                        LangChain4j.this.toParts(aiMessage).stream().map(Part::functionCall).forEach(functionCall -> functionCall.ifPresent(function -> emitter.onNext((Object)LlmResponse.builder().content(Content.fromParts((Part[])new Part[]{Part.fromFunctionCall((String)function.name().orElse(""), function.args().orElse(Map.of()))})).build())));
                    }
                    emitter.onComplete();
                }

                public void onError(Throwable throwable) {
                    emitter.onError(throwable);
                }
            }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
        }
        if (this.chatModel == null) {
            return Flowable.error((Throwable)new IllegalStateException("ChatModel is not configured"));
        }
        ChatRequest chatRequest = this.toChatRequest(llmRequest);
        ChatResponse chatResponse = this.chatModel.chat(chatRequest);
        LlmResponse llmResponse = this.toLlmResponse(chatResponse);
        return Flowable.just((Object)llmResponse);
    }

    private ChatRequest toChatRequest(LlmRequest llmRequest) {
        ChatRequest.Builder requestBuilder = ChatRequest.builder();
        List<ToolSpecification> toolSpecifications = this.toToolSpecifications(llmRequest);
        requestBuilder.toolSpecifications(toolSpecifications);
        if (llmRequest.config().isPresent()) {
            GenerateContentConfig generateContentConfig = (GenerateContentConfig)llmRequest.config().get();
            generateContentConfig.temperature().ifPresent(temp -> requestBuilder.temperature(Double.valueOf(temp.doubleValue())));
            generateContentConfig.topP().ifPresent(topP -> requestBuilder.topP(Double.valueOf(topP.doubleValue())));
            generateContentConfig.topK().ifPresent(topK -> requestBuilder.topK(Integer.valueOf(topK.intValue())));
            generateContentConfig.maxOutputTokens().ifPresent(arg_0 -> ((ChatRequest.Builder)requestBuilder).maxOutputTokens(arg_0));
            generateContentConfig.stopSequences().ifPresent(arg_0 -> ((ChatRequest.Builder)requestBuilder).stopSequences(arg_0));
            generateContentConfig.frequencyPenalty().ifPresent(freqPenalty -> requestBuilder.frequencyPenalty(Double.valueOf(freqPenalty.doubleValue())));
            generateContentConfig.presencePenalty().ifPresent(presPenalty -> requestBuilder.presencePenalty(Double.valueOf(presPenalty.doubleValue())));
            if (generateContentConfig.toolConfig().isPresent()) {
                ToolConfig toolConfig = (ToolConfig)generateContentConfig.toolConfig().get();
                toolConfig.functionCallingConfig().ifPresent(functionCallingConfig -> functionCallingConfig.mode().ifPresent(functionMode -> {
                    if (functionMode.knownEnum().equals((Object)FunctionCallingConfigMode.Known.AUTO)) {
                        requestBuilder.toolChoice(ToolChoice.AUTO);
                    } else if (functionMode.knownEnum().equals((Object)FunctionCallingConfigMode.Known.ANY)) {
                        requestBuilder.toolChoice(ToolChoice.REQUIRED);
                        functionCallingConfig.allowedFunctionNames().ifPresent(allowedFunctionNames -> requestBuilder.toolSpecifications(toolSpecifications.stream().filter(toolSpecification -> allowedFunctionNames.contains(toolSpecification.name())).toList()));
                    } else if (functionMode.knownEnum().equals((Object)FunctionCallingConfigMode.Known.NONE)) {
                        requestBuilder.toolSpecifications(List.of());
                    }
                }));
                toolConfig.retrievalConfig().ifPresent(retrievalConfig -> {});
            }
        }
        return requestBuilder.messages(this.toMessages(llmRequest)).build();
    }

    private List<ChatMessage> toMessages(LlmRequest llmRequest) {
        ArrayList<SystemMessage> messages = new ArrayList<SystemMessage>(llmRequest.getSystemInstructions().stream().map(SystemMessage::from).toList());
        llmRequest.contents().forEach(content -> messages.addAll(this.toChatMessage((Content)content)));
        return messages;
    }

    private List<ChatMessage> toChatMessage(Content content) {
        String role;
        return switch (role = ((String)content.role().orElseThrow()).toLowerCase()) {
            case "user" -> this.toUserOrToolResultMessage(content);
            case "model", "assistant" -> List.of(this.toAiMessage(content));
            default -> throw new IllegalStateException("Unexpected role: " + role);
        };
    }

    private List<ChatMessage> toUserOrToolResultMessage(Content content) {
        ArrayList<ToolExecutionResultMessage> toolExecutionResultMessages = new ArrayList<ToolExecutionResultMessage>();
        ArrayList<ToolExecutionRequest> toolExecutionRequests = new ArrayList<ToolExecutionRequest>();
        ArrayList<Object> lc4jContents = new ArrayList<Object>();
        for (Part part : content.parts().orElse(List.of())) {
            if (part.text().isPresent()) {
                lc4jContents.add(TextContent.from((String)((String)part.text().get())));
                continue;
            }
            if (part.functionResponse().isPresent()) {
                FunctionResponse functionResponse = (FunctionResponse)part.functionResponse().get();
                toolExecutionResultMessages.add(ToolExecutionResultMessage.from((String)((String)functionResponse.id().orElseThrow()), (String)((String)functionResponse.name().orElseThrow()), (String)this.toJson(functionResponse.response().orElseThrow())));
                continue;
            }
            if (part.functionCall().isPresent()) {
                FunctionCall functionCall = (FunctionCall)part.functionCall().get();
                toolExecutionRequests.add(ToolExecutionRequest.builder().id((String)functionCall.id().orElseThrow()).name((String)functionCall.name().orElseThrow()).arguments(this.toJson(functionCall.args().orElse(Map.of()))).build());
                continue;
            }
            if (part.inlineData().isPresent()) {
                Blob blob = (Blob)part.inlineData().get();
                if (blob.mimeType().isEmpty() || blob.data().isEmpty()) {
                    throw new IllegalArgumentException("Mime type and data required");
                }
                byte[] bytes = (byte[])blob.data().get();
                String mimeType = (String)blob.mimeType().get();
                Base64.Encoder encoder = Base64.getEncoder();
                AudioContent lc4jContent = null;
                if (mimeType.startsWith("audio/")) {
                    lc4jContent = AudioContent.from((Audio)Audio.builder().base64Data(encoder.encodeToString(bytes)).mimeType(mimeType).build());
                } else if (mimeType.startsWith("video/")) {
                    lc4jContent = VideoContent.from((Video)Video.builder().base64Data(encoder.encodeToString(bytes)).mimeType(mimeType).build());
                } else if (mimeType.startsWith("image/")) {
                    lc4jContent = ImageContent.from((Image)Image.builder().base64Data(encoder.encodeToString(bytes)).mimeType(mimeType).build());
                } else if (mimeType.startsWith("application/pdf")) {
                    lc4jContent = PdfFileContent.from((PdfFile)PdfFile.builder().base64Data(encoder.encodeToString(bytes)).mimeType(mimeType).build());
                } else if (mimeType.startsWith("text/") || mimeType.equals("application/json") || mimeType.endsWith("+json") || mimeType.endsWith("+xml")) {
                    lc4jContents.add(TextContent.from((String)new String(bytes, StandardCharsets.UTF_8)));
                }
                if (lc4jContent != null) {
                    lc4jContents.add(lc4jContent);
                    continue;
                }
                throw new IllegalArgumentException("Unknown or unhandled mime type: " + mimeType);
            }
            throw new IllegalStateException("Text, media or functionCall is expected, but was: " + part);
        }
        if (!toolExecutionResultMessages.isEmpty()) {
            return new ArrayList<ChatMessage>(toolExecutionResultMessages);
        }
        if (!toolExecutionRequests.isEmpty()) {
            return toolExecutionRequests.stream().map(xva$0 -> AiMessage.aiMessage((ToolExecutionRequest[])new ToolExecutionRequest[]{xva$0})).map(msg -> msg).toList();
        }
        return List.of(UserMessage.from(lc4jContents));
    }

    private AiMessage toAiMessage(Content content) {
        ArrayList texts = new ArrayList();
        ArrayList toolExecutionRequests = new ArrayList();
        content.parts().orElse(List.of()).forEach(part -> {
            if (part.text().isPresent()) {
                texts.add((String)part.text().get());
            } else if (part.functionCall().isPresent()) {
                FunctionCall functionCall = (FunctionCall)part.functionCall().get();
                ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().id((String)functionCall.id().orElseThrow()).name((String)functionCall.name().orElseThrow()).arguments(this.toJson(functionCall.args().orElseThrow())).build();
                toolExecutionRequests.add(toolExecutionRequest);
            } else {
                throw new IllegalStateException("Either text or functionCall is expected, but was: " + part);
            }
        });
        return AiMessage.builder().text(String.join((CharSequence)"\n", texts)).toolExecutionRequests(toolExecutionRequests).build();
    }

    private String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<ToolSpecification> toToolSpecifications(LlmRequest llmRequest) {
        ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
        llmRequest.tools().values().forEach(baseTool -> {
            FunctionDeclaration functionDeclaration;
            if (baseTool.declaration().isPresent()) {
                functionDeclaration = (FunctionDeclaration)baseTool.declaration().get();
                if (!functionDeclaration.parameters().isPresent()) {
                    throw new IllegalStateException("Tool lacking parameters: " + baseTool);
                }
            } else {
                throw new IllegalStateException("Tool lacking declaration: " + baseTool);
            }
            Schema schema = (Schema)functionDeclaration.parameters().get();
            ToolSpecification toolSpecification = ToolSpecification.builder().name(baseTool.name()).description(baseTool.description()).parameters(this.toParameters(schema)).build();
            toolSpecifications.add(toolSpecification);
        });
        return toolSpecifications;
    }

    private JsonObjectSchema toParameters(Schema schema) {
        if (schema.type().isPresent() && ((Type)schema.type().get()).knownEnum().equals((Object)Type.Known.OBJECT)) {
            return JsonObjectSchema.builder().addProperties(this.toProperties(schema)).required(schema.required().orElse(List.of())).build();
        }
        throw new UnsupportedOperationException("LangChain4jLlm does not support schema of type: " + schema.type());
    }

    private Map<String, JsonSchemaElement> toProperties(Schema schema) {
        Map<String, Schema> properties = schema.properties().orElse(Map.of());
        HashMap<String, JsonSchemaElement> result = new HashMap<String, JsonSchemaElement>();
        properties.forEach((k, v) -> result.put((String)k, this.toJsonSchemaElement((Schema)v)));
        return result;
    }

    private JsonSchemaElement toJsonSchemaElement(Schema schema) {
        if (schema != null && schema.type().isPresent()) {
            Type type = (Type)schema.type().get();
            return switch (type.knownEnum()) {
                default -> throw new IncompatibleClassChangeError();
                case Type.Known.STRING -> JsonStringSchema.builder().description((String)schema.description().orElse(null)).build();
                case Type.Known.NUMBER -> JsonNumberSchema.builder().description((String)schema.description().orElse(null)).build();
                case Type.Known.INTEGER -> JsonIntegerSchema.builder().description((String)schema.description().orElse(null)).build();
                case Type.Known.BOOLEAN -> JsonBooleanSchema.builder().description((String)schema.description().orElse(null)).build();
                case Type.Known.ARRAY -> JsonArraySchema.builder().description((String)schema.description().orElse(null)).items(this.toJsonSchemaElement((Schema)schema.items().orElseThrow())).build();
                case Type.Known.OBJECT -> this.toParameters(schema);
                case Type.Known.TYPE_UNSPECIFIED -> throw new UnsupportedFeatureException("LangChain4jLlm does not support schema of type: " + type);
            };
        }
        throw new IllegalArgumentException("Schema type cannot be null or absent");
    }

    private LlmResponse toLlmResponse(ChatResponse chatResponse) {
        Content content = Content.builder().role("model").parts(this.toParts(chatResponse.aiMessage())).build();
        return LlmResponse.builder().content(content).build();
    }

    private List<Part> toParts(AiMessage aiMessage) {
        if (aiMessage.hasToolExecutionRequests()) {
            ArrayList<Part> parts = new ArrayList<Part>();
            aiMessage.toolExecutionRequests().forEach(toolExecutionRequest -> {
                FunctionCall functionCall = FunctionCall.builder().id(toolExecutionRequest.id() != null ? toolExecutionRequest.id() : UUID.randomUUID().toString()).name(toolExecutionRequest.name()).args(this.toArgs((ToolExecutionRequest)toolExecutionRequest)).build();
                Part part = Part.builder().functionCall(functionCall).build();
                parts.add(part);
            });
            return parts;
        }
        Part part = Part.builder().text(aiMessage.text()).build();
        return List.of(part);
    }

    private Map<String, Object> toArgs(ToolExecutionRequest toolExecutionRequest) {
        try {
            return (Map)this.objectMapper.readValue(toolExecutionRequest.arguments(), MAP_TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public BaseLlmConnection connect(LlmRequest llmRequest) {
        throw new UnsupportedOperationException("Live connection is not supported for LangChain4j models.");
    }
}

