/*
 * Decompiled with CFR 0.152.
 */
package com.github.gmazzo.parallel;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public abstract class GenericParallelIntentService<K>
extends Service {
    private final Map<K, ExecutorService> executors = new HashMap<K, ExecutorService>();
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable onJobFinished = new Runnable(){

        @Override
        public void run() {
            if (--GenericParallelIntentService.this.jobsCount <= 0) {
                GenericParallelIntentService.this.stopSelf();
            }
        }
    };
    private int jobsCount;

    @Nullable
    protected abstract K getQueueKeyFor(@NonNull Intent var1);

    @NonNull
    protected abstract ExecutorService createExecutorFor(@Nullable K var1, @NonNull Intent var2);

    @WorkerThread
    protected abstract void onHandleIntent(@NonNull Intent var1);

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 2;
    }

    public void onStart(final Intent intent, int startId) {
        K key = this.getQueueKeyFor(intent);
        ExecutorService executor = this.executors.get(key);
        if (executor == null || executor.isShutdown()) {
            executor = this.createExecutorFor(key, intent);
            this.executors.put(key, executor);
        }
        ++this.jobsCount;
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    GenericParallelIntentService.this.onHandleIntent(intent);
                }
                catch (RuntimeException throwable) {
                    GenericParallelIntentService.this.onTaskFailed(intent, throwable);
                }
                finally {
                    GenericParallelIntentService.this.handler.post(GenericParallelIntentService.this.onJobFinished);
                }
            }
        });
    }

    @WorkerThread
    protected void onTaskFailed(Intent intent, final RuntimeException throwable) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                throw throwable;
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        int leftTasks = 0;
        for (ExecutorService executor : this.executors.values()) {
            leftTasks += executor.shutdownNow().size();
        }
        if (leftTasks > 0) {
            throw new IllegalStateException(leftTasks + " tasks were left!");
        }
    }
}

