/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mock.matchers;

import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;
import okhttp3.mock.matchers.Matcher;

public class OrMatcher
implements Matcher {
    private final List<Matcher> matchers = new ArrayList<Matcher>();

    public OrMatcher(Matcher left, Matcher right) {
        this.add(left);
        this.add(right);
    }

    public void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    @Override
    public boolean matches(Request request) {
        for (Matcher matcher : this.matchers) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String failReason(Request request) {
        StringBuilder sb = new StringBuilder("or(");
        boolean first = true;
        for (Matcher matcher : this.matchers) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(matcher.failReason(request));
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("or(");
        boolean first = true;
        for (Matcher matcher : this.matchers) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(matcher);
        }
        sb.append(')');
        return sb.toString();
    }
}

