/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mock.matchers;

import okhttp3.Request;
import okhttp3.mock.HttpMethod;
import okhttp3.mock.matchers.Matcher;
import okhttp3.mock.matchers.MatcherHelper;

public class MethodMatcher
implements Matcher {
    private final String method;

    public MethodMatcher(@HttpMethod String method) {
        this.method = method;
    }

    @Override
    public boolean matches(Request request) {
        return this.method.equalsIgnoreCase(request.method());
    }

    @Override
    public String failReason(Request request) {
        return MatcherHelper.reason(this.method, request.method());
    }

    public String toString() {
        return "method(" + this.method + ")";
    }
}

