/*
 * Decompiled with CFR 0.152.
 */
package com.gluehome.common.domain.framework;

import com.gluehome.common.domain.extension.DateExtensionsKt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/gluehome/common/domain/framework/DateMapper;", "", "()V", "customFormat", "Ljava/text/SimpleDateFormat;", "ordinal", "", "dateToCardHeaderTitle", "date", "Ljava/util/Date;", "formatDate", "format", "toDayMonthYearTimestamp", "stringDate", "transformStringDateInIntoTimestamp", "", "dateFormat", "domain"})
public final class DateMapper {
    @NotNull
    public final String formatDate(@NotNull Date date, @NotNull String format) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        try {
            String string2 = new SimpleDateFormat(format, Locale.getDefault()).format(date);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(format,\u2026etDefault()).format(date)");
            string = string2;
        }
        catch (Exception exception) {
            string = "Unable to parse date";
        }
        return string;
    }

    @NotNull
    public final String dateToCardHeaderTitle(@NotNull Date date) {
        String string;
        Calendar cal;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar calendar = cal = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
        calendar.setTime(date);
        int day = cal.get(5);
        switch (day) {
            case 1: 
            case 21: 
            case 31: {
                String string2 = this.customFormat("st").format(date);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"customFormat(\"st\").format(date)");
                break;
            }
            case 2: 
            case 22: {
                String string3 = this.customFormat("nd").format(date);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"customFormat(\"nd\").format(date)");
                break;
            }
            case 3: 
            case 23: {
                String string4 = this.customFormat("rd").format(date);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"customFormat(\"rd\").format(date)");
                break;
            }
            default: {
                String string5 = this.customFormat("th").format(date);
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"customFormat(\"th\").format(date)");
            }
        }
        return string;
    }

    private final SimpleDateFormat customFormat(String ordinal) {
        return new SimpleDateFormat("EEEE, MMMM d'" + ordinal + '\'', Locale.getDefault());
    }

    @NotNull
    public final Date toDayMonthYearTimestamp(@NotNull String stringDate) {
        Intrinsics.checkParameterIsNotNull((Object)stringDate, (String)"stringDate");
        return DateExtensionsKt.toDate(this.transformStringDateInIntoTimestamp(stringDate, "dd/MM/yy"));
    }

    private final long transformStringDateInIntoTimestamp(String stringDate, String dateFormat) {
        Date date;
        Date date2 = null;
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, Locale.getDefault());
        try {
            Date date3 = formatter.parse(stringDate);
            Intrinsics.checkExpressionValueIsNotNull((Object)date3, (String)"formatter.parse(stringDate)");
            date = date3;
        }
        catch (ParseException e) {
            e.printStackTrace();
            date = new Date();
        }
        date2 = date;
        return date2.getTime();
    }
}

