/*
 * Decompiled with CFR 0.152.
 */
package com.giacomoparisi.recyclerdroid.core.holder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\f2\b\b\u0001\u0010\u0015\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0015\u001a\u00020\fJ)\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u0002H\u0001\"\b\b\u0001\u0010\u0001*\u00020\t*\u00020\f\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/giacomoparisi/recyclerdroid/core/holder/BaseDroidViewHolder;", "T", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "factory", "Lkotlin/Function3;", "Landroid/view/LayoutInflater;", "", "Landroid/view/View;", "(Landroid/view/ViewGroup;Lkotlin/jvm/functions/Function3;)V", "layoutId", "", "(Landroid/view/ViewGroup;I)V", "itemView", "(Landroid/view/View;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "getColor", "id", "getString", "", "formatArgs", "", "", "(I[Ljava/lang/Object;)Ljava/lang/String;", "getView", "(I)Landroid/view/View;", "core_release"})
public abstract class BaseDroidViewHolder<T>
extends RecyclerView.ViewHolder {
    @NotNull
    public final Context getContext() {
        View view = this.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
        return context;
    }

    @NotNull
    public final String getString(@StringRes int id) {
        String string = this.getContext().getString(id);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(id)");
        return string;
    }

    @NotNull
    public final String getString(@StringRes int id, Object ... formatArgs) {
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        String string = this.getContext().getString(id, new Object[]{formatArgs});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(id, formatArgs)");
        return string;
    }

    public final int getColor(@ColorRes int id) {
        return ContextCompat.getColor((Context)this.getContext(), (int)id);
    }

    @NotNull
    public final <T extends View> T getView(int $this$getView) {
        View view = this.itemView.findViewById($this$getView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"this@BaseDroidViewHolder\u2026emView.findViewById(this)");
        return (T)view;
    }

    public BaseDroidViewHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
    }

    public BaseDroidViewHolder(@NotNull ViewGroup parent, @NotNull Function3<? super LayoutInflater, ? super ViewGroup, ? super Boolean, ? extends View> factory) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"LayoutInflater.from(parent.context)");
        this((View)factory.invoke((Object)layoutInflater, (Object)parent, (Object)false));
    }

    public BaseDroidViewHolder(@NotNull ViewGroup parent, final @LayoutRes int layoutId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(parent, (Function3<? super LayoutInflater, ? super ViewGroup, ? super Boolean, ? extends View>)((Function3)new Function3<LayoutInflater, ViewGroup, Boolean, View>(){

            @NotNull
            public final View invoke(@NotNull LayoutInflater layoutInflater, @NotNull ViewGroup viewGroup, boolean b) {
                Intrinsics.checkNotNullParameter((Object)layoutInflater, (String)"layoutInflater");
                Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
                View view = layoutInflater.inflate(layoutId, viewGroup, b);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"layoutInflater.inflate(layoutId, viewGroup, b)");
                return view;
            }
        }));
    }
}

