/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSAttribute;
import sharpen.core.csharp.ast.CSDocNode;
import sharpen.core.csharp.ast.CSNode;
import sharpen.core.csharp.ast.CSVisibility;

public abstract class CSMember
extends CSNode {
    protected String _name;
    protected CSVisibility _visibility = CSVisibility.Internal;
    protected List<CSDocNode> _docs;
    private List<CSAttribute> _attributes = new ArrayList<CSAttribute>();
    private boolean _newModifier;

    protected CSMember(String name) {
        this._name = name;
    }

    public String name() {
        return this._name;
    }

    public void visibility(CSVisibility visibility) {
        this._visibility = visibility;
    }

    public CSVisibility visibility() {
        return this._visibility;
    }

    public void addDoc(CSDocNode node) {
        if (null == this._docs) {
            this._docs = new ArrayList<CSDocNode>();
        }
        this._docs.add(node);
    }

    public List<CSDocNode> docs() {
        if (null == this._docs) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._docs);
    }

    public void addAttribute(CSAttribute attribute) {
        this._attributes.add(attribute);
    }

    public boolean removeAttribute(String name) {
        for (CSAttribute at : this._attributes) {
            if (!at.name().equals(name)) continue;
            this._attributes.remove(at);
            return true;
        }
        return false;
    }

    public List<CSAttribute> attributes() {
        return Collections.unmodifiableList(this._attributes);
    }

    public String signature() {
        return this._name;
    }

    public boolean isNewModifier() {
        return this._newModifier;
    }

    public void setNewModifier(boolean newModifier) {
        this._newModifier = newModifier;
    }
}

