/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.HashMap;
import java.util.Map;

public class NamingStrategy {
    public static final NamingStrategy DEFAULT = new NamingStrategy();
    static Map<String, String> _identifierMappings = new HashMap<String, String>();

    private static void keywords(String ... values) {
        for (String value : values) {
            NamingStrategy.keyword(value);
        }
    }

    private static void keyword(String value) {
        NamingStrategy.mapIdentifier(value, "@" + value);
    }

    private static void mapIdentifier(String from, String to) {
        _identifierMappings.put(from, to);
    }

    public String identifier(String name) {
        String mapped = _identifierMappings.get(name);
        return mapped != null ? mapped : name;
    }

    public String methodName(String name) {
        return this.namespacePart(name);
    }

    public String namespace(String name) {
        StringBuilder builder = new StringBuilder();
        for (String part : name.split("\\.")) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(this.namespacePart(part));
        }
        return builder.toString();
    }

    protected String namespacePart(String part) {
        return this.identifier(part);
    }

    static {
        NamingStrategy.keywords("as", "base", "bool", "checked", "decimal", "event", "explicit", "extern", "false", "fixed", "foreach", "implicit", "in", "internal", "is", "namespace", "null", "object", "operator", "out", "override", "params", "readonly", "ref", "sbyte", "sealed", "sizeof", "stackalloc", "string", "struct", "true", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual");
        NamingStrategy.mapIdentifier("lock", "Lock");
        NamingStrategy.mapIdentifier("delegate", "delegate_");
    }
}

