/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.start;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.permissions.start.IStartActivityDelegate;
import com.hjq.permissions.start.StartActivityDelegateByActivity;
import com.hjq.permissions.start.StartActivityDelegateByContext;
import com.hjq.permissions.start.StartActivityDelegateByFragmentAndroid;
import com.hjq.permissions.start.StartActivityDelegateByFragmentAndroidX;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.Iterator;
import java.util.List;

public final class StartActivityAgent {
    public static void startActivity(@NonNull Context context, @NonNull List<Intent> intentList) {
        StartActivityAgent.startActivity(context, new StartActivityDelegateByContext(context), intentList);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull List<Intent> intentList) {
        StartActivityAgent.startActivity((Context)activity, new StartActivityDelegateByActivity(activity), intentList);
    }

    public static void startActivity(@NonNull Fragment fragment, @NonNull List<Intent> intentList) {
        StartActivityAgent.startActivity((Context)fragment.getActivity(), new StartActivityDelegateByFragmentAndroid(fragment), intentList);
    }

    public static void startActivity(@NonNull androidx.fragment.app.Fragment fragment, @NonNull List<Intent> intentList) {
        StartActivityAgent.startActivity((Context)fragment.getActivity(), new StartActivityDelegateByFragmentAndroidX(fragment), intentList);
    }

    public static void startActivity(@NonNull Context context, @NonNull IStartActivityDelegate delegate, @NonNull List<Intent> intentList) {
        Iterator<Intent> iterator = intentList.iterator();
        while (iterator.hasNext()) {
            Intent intent = iterator.next();
            if (PermissionUtils.areActivityIntent(context, intent)) continue;
            iterator.remove();
        }
        if (intentList.isEmpty()) {
            intentList.add(PermissionSettingPage.getAndroidSettingsIntent());
        }
        for (Intent intent : intentList) {
            if (intent == null) continue;
            try {
                delegate.startActivity(intent);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull List<Intent> intentList, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult((Context)activity, new StartActivityDelegateByActivity(activity), intentList, requestCode);
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull List<Intent> intentList, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult((Context)fragment.getActivity(), new StartActivityDelegateByFragmentAndroid(fragment), intentList, requestCode);
    }

    public static void startActivityForResult(@NonNull androidx.fragment.app.Fragment fragment, @NonNull List<Intent> intentList, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult((Context)fragment.getActivity(), new StartActivityDelegateByFragmentAndroidX(fragment), intentList, requestCode);
    }

    public static void startActivityForResult(@NonNull Context context, @NonNull IStartActivityDelegate delegate, @NonNull List<Intent> intentList, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult(context, delegate, intentList, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Context context, @NonNull IStartActivityDelegate delegate, @NonNull List<Intent> intentList, @IntRange(from=1L, to=65535L) int requestCode, @Nullable Runnable ignoreActivityResultCallback) {
        Intent intent;
        Iterator<Intent> iterator = intentList.iterator();
        while (iterator.hasNext()) {
            intent = iterator.next();
            if (PermissionUtils.areActivityIntent(context, intent)) continue;
            iterator.remove();
        }
        if (intentList.isEmpty()) {
            intentList.add(PermissionSettingPage.getAndroidSettingsIntent());
        }
        iterator = intentList.iterator();
        while (iterator.hasNext()) {
            intent = iterator.next();
            if (intent == null) continue;
            try {
                delegate.startActivityForResult(intent, requestCode);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!iterator.hasNext() || ignoreActivityResultCallback == null) continue;
                ignoreActivityResultCallback.run();
            }
        }
    }
}

