/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ActivityManifestInfo;
import com.hjq.permissions.manifest.node.IntentFilterManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public abstract class HealthDataBasePermission
extends DangerousPermission {
    protected HealthDataBasePermission() {
    }

    protected HealthDataBasePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        return PermissionPageType.OPAQUE_ACTIVITY;
    }

    @Override
    public String getPermissionGroup(@NonNull Context context) {
        return "health_group";
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        List<Intent> intentList = super.getPermissionSettingIntents(context, skipRequest);
        if (PermissionVersion.isAndroid14() && !PermissionVersion.isAndroid16()) {
            Intent intent;
            ArrayList<Intent> healthIntentList = new ArrayList<Intent>(3);
            if (!PermissionVersion.isAndroid15()) {
                String action = "android.health.connect.action.MANAGE_HEALTH_PERMISSIONS";
                intent = new Intent(action);
                intent.putExtra("android.intent.extra.PACKAGE_NAME", context.getPackageName());
                healthIntentList.add(intent);
                intent = new Intent(action);
                healthIntentList.add(intent);
            }
            intent = new Intent("android.health.connect.action.HEALTH_HOME_SETTINGS");
            healthIntentList.add(intent);
            intentList.addAll(0, healthIntentList);
        }
        return intentList;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        String healthAction = PermissionVersion.isAndroid16() ? "android.intent.action.VIEW_PERMISSION_USAGE" : "android.intent.action.VIEW_PERMISSION_USAGE";
        String healthCategory = PermissionVersion.isAndroid16() ? "android.intent.category.HEALTH_PERMISSIONS" : "android.intent.category.HEALTH_PERMISSIONS";
        boolean registeredHealthPrivacyPolicyAction = false;
        for (ActivityManifestInfo activityInfo : manifestInfo.activityInfoList) {
            List<IntentFilterManifestInfo> intentFilterInfoList = activityInfo.intentFilterInfoList;
            if (intentFilterInfoList == null) continue;
            for (IntentFilterManifestInfo intentFilterInfo : intentFilterInfoList) {
                if (!intentFilterInfo.actionList.contains(healthAction) || !intentFilterInfo.categoryList.contains(healthCategory)) continue;
                registeredHealthPrivacyPolicyAction = true;
                break;
            }
            if (!registeredHealthPrivacyPolicyAction) continue;
            break;
        }
        if (!registeredHealthPrivacyPolicyAction) {
            String xmlCode = "\t\t<intent-filter>\n\t\t    <action android:name=\"" + healthAction + "\" />\n\t\t    <category android:name=\"" + healthCategory + "\" />\n\t\t</intent-filter>";
            throw new IllegalArgumentException("Please add an intent filter for \"" + activity.getClass() + "\" in the AndroidManifest.xml file.\n" + xmlCode);
        }
    }
}

