/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.fragment.factory;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.hjq.permissions.core.OnPermissionFragmentCallback;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.fragment.impl.androidx.PermissionAndroidXFragment;
import com.hjq.permissions.fragment.impl.androidx.PermissionAndroidXFragmentByRequestPermissions;
import com.hjq.permissions.fragment.impl.androidx.PermissionAndroidXFragmentByStartActivity;
import com.hjq.permissions.manager.PermissionRequestCodeManager;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import java.util.List;

public final class PermissionFragmentFactoryByAndroidX
extends PermissionFragmentFactory<FragmentActivity, FragmentManager> {
    public PermissionFragmentFactoryByAndroidX(@NonNull FragmentActivity activity, @NonNull FragmentManager fragmentManager) {
        super(activity, fragmentManager);
    }

    @Override
    public void createAndCommitFragment(@NonNull List<IPermission> permissions, @NonNull PermissionChannel permissionChannel, @Nullable OnPermissionFragmentCallback callback) {
        int maxRequestCode;
        PermissionAndroidXFragment fragment = permissionChannel == PermissionChannel.REQUEST_PERMISSIONS ? new PermissionAndroidXFragmentByRequestPermissions() : new PermissionAndroidXFragmentByStartActivity();
        if (permissionChannel == PermissionChannel.REQUEST_PERMISSIONS) {
            try {
                FragmentActivity activity = (FragmentActivity)this.getActivity();
                activity.validateRequestPermissionsRequestCode(65535);
                maxRequestCode = 65535;
            }
            catch (IllegalArgumentException ignore) {
                maxRequestCode = 255;
            }
            catch (Exception ignore) {
                maxRequestCode = 65535;
            }
        } else {
            maxRequestCode = 65535;
        }
        int requestCode = PermissionRequestCodeManager.generateRandomRequestCode(maxRequestCode);
        fragment.setArguments(this.generatePermissionArguments(permissions, requestCode));
        fragment.setRetainInstance(true);
        fragment.setNonSystemRestartMark(true);
        fragment.setPermissionFragmentCallback(callback);
        fragment.commitFragmentAttach((FragmentManager)this.getFragmentManager());
    }
}

