/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.fragment.factory;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.permissions.core.OnPermissionFragmentCallback;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import java.util.ArrayList;
import java.util.List;

public abstract class PermissionFragmentFactory<A extends Activity, M> {
    @NonNull
    private final A mActivity;
    @NonNull
    private final M mFragmentManager;

    protected PermissionFragmentFactory(@NonNull A activity, @NonNull M fragmentManager) {
        this.mActivity = activity;
        this.mFragmentManager = fragmentManager;
    }

    @NonNull
    protected A getActivity() {
        return this.mActivity;
    }

    @NonNull
    protected M getFragmentManager() {
        return this.mFragmentManager;
    }

    public abstract void createAndCommitFragment(@NonNull List<IPermission> var1, @NonNull PermissionChannel var2, @Nullable OnPermissionFragmentCallback var3);

    @NonNull
    protected Bundle generatePermissionArguments(@NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        Bundle bundle = new Bundle();
        bundle.putInt("request_code", requestCode);
        if (permissions instanceof ArrayList) {
            bundle.putParcelableArrayList("request_permissions", (ArrayList)permissions);
        } else {
            bundle.putParcelableArrayList("request_permissions", new ArrayList<IPermission>(permissions));
        }
        return bundle;
    }
}

