/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class PermissionSettingPage {
    private static final String SMARTISAN_SECURITY_COMPONENT_APP_PACKAGE_NAME = "com.smartisanos.security";
    private static final String[] HUA_WEI_MOBILE_MANAGER_APP_PACKAGE_NAMES = new String[]{"com.huawei.systemmanager"};
    private static final String[] XIAO_MI_MOBILE_MANAGER_APP_PACKAGE_NAMES = new String[]{"com.miui.securitycenter"};
    private static final String[] OPPO_SAFE_CENTER_APP_PACKAGE_NAMES = new String[]{"com.coloros.safecenter", "com.oplus.safecenter", "com.color.safecenter", "com.oppo.safe"};
    private static final String[] VIVO_MOBILE_MANAGER_APP_PACKAGE_NAMES = new String[]{"com.bairenkeji.icaller", "com.iqoo.secure"};
    private static final String[] SMARTISAN_SECURITY_CENTER_APP_PACKAGE_NAMES = new String[]{"com.smartisanos.securitycenter", "com.smartisanos.security"};

    @NonNull
    public static Intent getOneUiPermissionPageIntent(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.Settings$AppOpsDetailsActivity");
        Bundle extraShowFragmentArguments = new Bundle();
        extraShowFragmentArguments.putString("package", context.getPackageName());
        intent.putExtra(":settings:show_fragment_args", extraShowFragmentArguments);
        intent.setData(PermissionUtils.getPackageNameUri(context));
        return intent;
    }

    @NonNull
    public static List<Intent> getHuaWeiMobileManagerAppIntent(Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(1);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            for (String appPackageName : HUA_WEI_MOBILE_MANAGER_APP_PACKAGE_NAMES) {
                Intent intent = packageManager.getLaunchIntentForPackage(appPackageName);
                if (intent == null) continue;
                intentList.add(intent);
            }
        }
        return intentList;
    }

    @NonNull
    public static List<Intent> getXiaoMiMobileManagerAppIntent(Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2 + XIAO_MI_MOBILE_MANAGER_APP_PACKAGE_NAMES.length);
        Intent intent = new Intent("miui.intent.action.APP_MANAGER");
        intentList.add(intent);
        intent = new Intent("miui.intent.action.SECURITY_CENTER");
        intentList.add(intent);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            for (String appPackageName : XIAO_MI_MOBILE_MANAGER_APP_PACKAGE_NAMES) {
                intent = packageManager.getLaunchIntentForPackage(appPackageName);
                if (intent == null) continue;
                intentList.add(intent);
            }
        }
        return intentList;
    }

    @NonNull
    public static List<Intent> getOppoSafeCenterAppIntent(Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(OPPO_SAFE_CENTER_APP_PACKAGE_NAMES.length);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            for (String appPackageName : OPPO_SAFE_CENTER_APP_PACKAGE_NAMES) {
                Intent intent = packageManager.getLaunchIntentForPackage(appPackageName);
                if (intent == null) continue;
                intentList.add(intent);
            }
        }
        return intentList;
    }

    @NonNull
    public static List<Intent> getVivoMobileManagerAppIntent(Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(VIVO_MOBILE_MANAGER_APP_PACKAGE_NAMES.length);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            for (String appPackageName : VIVO_MOBILE_MANAGER_APP_PACKAGE_NAMES) {
                Intent intent = packageManager.getLaunchIntentForPackage(appPackageName);
                if (intent == null) continue;
                intentList.add(intent);
            }
        }
        return intentList;
    }

    @NonNull
    public static List<Intent> getSmartisanSecurityCenterAppIntent(Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(SMARTISAN_SECURITY_CENTER_APP_PACKAGE_NAMES.length);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            for (String appPackageName : SMARTISAN_SECURITY_CENTER_APP_PACKAGE_NAMES) {
                Intent intent = packageManager.getLaunchIntentForPackage(appPackageName);
                if (intent == null) continue;
                intentList.add(intent);
            }
        }
        return intentList;
    }

    @NonNull
    public static Intent getXiaoMiApplicationPermissionPageIntent(@NonNull Context context) {
        return new Intent("miui.intent.action.APP_PERM_EDITOR").putExtra("extra_pkgname", context.getPackageName());
    }

    @NonNull
    public static Intent getMeiZuApplicationPermissionPageIntent(@NonNull Context context) {
        return new Intent("com.meizu.safe.security.SHOW_APPSEC").putExtra("packageName", context.getPackageName());
    }

    @NonNull
    public static List<Intent> getSmartisanPermissionPageIntent() {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2);
        Intent intent = new Intent("com.smartisanos.security.action.PACKAGE_OVERVIEW");
        intentList.add(intent);
        intent = new Intent();
        intent.setClassName(SMARTISAN_SECURITY_COMPONENT_APP_PACKAGE_NAME, "com.smartisanos.security.PackagesOverview");
        intentList.add(intent);
        return intentList;
    }

    @NonNull
    public static List<Intent> getCommonPermissionSettingIntent(@NonNull Context context) {
        return PermissionSettingPage.getCommonPermissionSettingIntent(context, null);
    }

    @NonNull
    public static List<Intent> getCommonPermissionSettingIntent(@NonNull Context context, IPermission ... permissions) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(4);
        intentList.add(PermissionSettingPage.getApplicationDetailsSettingsIntent(context, permissions));
        intentList.add(PermissionSettingPage.getManageApplicationSettingsIntent());
        intentList.add(PermissionSettingPage.getApplicationSettingsIntent());
        intentList.add(PermissionSettingPage.getAndroidSettingsIntent());
        return intentList;
    }

    @NonNull
    public static Intent getApplicationDetailsSettingsIntent(@NonNull Context context, IPermission ... permissions) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (permissions != null && permissions.length > 0 && DeviceOs.isColorOs()) {
            Bundle bundle = new Bundle();
            List<String> permissionList = PermissionUtils.convertPermissionList(permissions);
            bundle.putStringArrayList("permissionList", (ArrayList)(permissionList instanceof ArrayList ? (ArrayList<Object>)permissionList : new ArrayList<String>(permissionList)));
            intent.putExtras(bundle);
            intent.putExtra("isGetPermission", true);
        }
        return intent;
    }

    @NonNull
    public static Intent getManageApplicationSettingsIntent() {
        return new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
    }

    @NonNull
    public static Intent getApplicationSettingsIntent() {
        return new Intent("android.settings.APPLICATION_SETTINGS");
    }

    @NonNull
    public static Intent getAndroidSettingsIntent() {
        return new Intent("android.settings.SETTINGS");
    }
}

