/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class PermissionApi {
    public static boolean isHealthPermission(@NonNull IPermission permission2) {
        return permission2.getPermissionName().startsWith("android.permission.health.");
    }

    public static boolean containsPermissionByStartActivity(@NonNull Context context, @Nullable List<IPermission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (IPermission permission2 : permissions) {
            if (permission2.getPermissionChannel(context) != PermissionChannel.START_ACTIVITY) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (IPermission permission2 : permissions) {
            if (permission2.isGrantedPermission(context)) continue;
            return false;
        }
        return true;
    }

    public static List<IPermission> getGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        ArrayList<IPermission> grantedList = new ArrayList<IPermission>(permissions.size());
        for (IPermission permission2 : permissions) {
            if (!permission2.isGrantedPermission(context)) continue;
            grantedList.add(permission2);
        }
        return grantedList;
    }

    public static List<IPermission> getDeniedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        ArrayList<IPermission> deniedList = new ArrayList<IPermission>(permissions.size());
        for (IPermission permission2 : permissions) {
            if (permission2.isGrantedPermission(context)) continue;
            deniedList.add(permission2);
        }
        return deniedList;
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<IPermission> permissions) {
        for (IPermission permission2 : permissions) {
            if (!permission2.isDoNotAskAgainPermission(activity)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static List<Intent> getBestPermissionSettingIntent(@NonNull Context context, @Nullable List<IPermission> permissions, boolean skipRequest) {
        List<Intent> currentPermissionIntentList;
        if (permissions == null || permissions.isEmpty()) {
            return PermissionSettingPage.getCommonPermissionSettingIntent(context);
        }
        ArrayList<IPermission> realPermissions = new ArrayList<IPermission>(permissions);
        for (IPermission permission2 : permissions) {
            if (permission2.getFromAndroidVersion(context) > PermissionVersion.getCurrentVersion()) {
                realPermissions.remove(permission2);
                continue;
            }
            List<IPermission> oldPermissions = permission2.getOldPermissions(context);
            if (oldPermissions == null || oldPermissions.isEmpty() || permission2.getPermissionChannel(context) != PermissionChannel.START_ACTIVITY && !PermissionApi.containsPermissionByStartActivity(context, oldPermissions)) continue;
            realPermissions.removeAll(oldPermissions);
        }
        if (realPermissions.isEmpty()) {
            return PermissionSettingPage.getCommonPermissionSettingIntent(context);
        }
        if (realPermissions.size() == 1) {
            return ((IPermission)realPermissions.get(0)).getPermissionSettingIntents(context, skipRequest);
        }
        List<Intent> prePermissionIntentList = ((IPermission)realPermissions.get(0)).getPermissionSettingIntents(context, skipRequest);
        for (int i = 1; i < realPermissions.size() && PermissionUtils.equalsIntentList(currentPermissionIntentList = ((IPermission)realPermissions.get(i)).getPermissionSettingIntents(context, skipRequest), prePermissionIntentList); ++i) {
            prePermissionIntentList = currentPermissionIntentList;
            if (i != realPermissions.size() - 1) continue;
            return currentPermissionIntentList;
        }
        return PermissionSettingPage.getCommonPermissionSettingIntent(context);
    }

    public static synchronized void addOldPermissionsByNewPermissions(@NonNull Context context, @NonNull List<IPermission> requestList) {
        int index = -1;
        while (++index < requestList.size()) {
            List<IPermission> oldPermissions;
            IPermission permission2 = requestList.get(index);
            if (PermissionVersion.getCurrentVersion() >= permission2.getFromAndroidVersion(context) || (oldPermissions = permission2.getOldPermissions(context)) == null || oldPermissions.isEmpty()) continue;
            for (IPermission oldPermission : oldPermissions) {
                if (PermissionUtils.containsPermission(requestList, oldPermission)) continue;
                requestList.add(++index, oldPermission);
            }
        }
    }

    public static int getMaxIntervalTimeByPermissions(@NonNull Context context, @Nullable List<IPermission> permissions) {
        if (permissions == null) {
            return 0;
        }
        int maxWaitTime = 0;
        for (IPermission permission2 : permissions) {
            int time = permission2.getRequestIntervalTime(context);
            if (time == 0) continue;
            maxWaitTime = Math.max(maxWaitTime, time);
        }
        return maxWaitTime;
    }

    public static int getMaxWaitTimeByPermissions(@NonNull Context context, @Nullable List<IPermission> permissions) {
        if (permissions == null) {
            return 0;
        }
        int maxWaitTime = 0;
        for (IPermission permission2 : permissions) {
            int time = permission2.getResultWaitTime(context);
            if (time == 0) continue;
            maxWaitTime = Math.max(maxWaitTime, time);
        }
        return maxWaitTime;
    }
}

