/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.core.OnPermissionFlowCallback;
import com.hjq.permissions.fragment.IFragmentCallback;
import com.hjq.permissions.fragment.IFragmentMethod;
import com.hjq.permissions.manager.ActivityOrientationManager;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.start.IStartActivityDelegate;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionTaskHandler;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public abstract class RequestPermissionDelegateImpl
implements IFragmentCallback {
    public static final String REQUEST_PERMISSIONS = "request_permissions";
    public static final String REQUEST_CODE = "request_code";
    @NonNull
    private final Object mTaskToken = new Object();
    private boolean mRequestFlag;
    private boolean mAlreadyRequest;
    private boolean mManualDetach;
    @NonNull
    private final IFragmentMethod<?, ?> mFragmentMethod;
    @Nullable
    private OnPermissionFlowCallback mCallBack;

    RequestPermissionDelegateImpl(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        this.mFragmentMethod = fragmentMethod;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void setCallback(@Nullable OnPermissionFlowCallback callback) {
        this.mCallBack = callback;
    }

    @Nullable
    OnPermissionFlowCallback getCallBack() {
        return this.mCallBack;
    }

    @Nullable
    Activity getActivity() {
        return this.mFragmentMethod.getActivity();
    }

    void commitDetach() {
        this.mManualDetach = true;
        this.mFragmentMethod.commitDetach();
    }

    boolean isFragmentUnavailable() {
        return !this.mFragmentMethod.isAdded() || this.mFragmentMethod.isRemoving();
    }

    void requestPermissions(@NonNull String[] permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        try {
            this.mFragmentMethod.requestPermissions(permissions, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    List<IPermission> getPermissionRequestList() {
        Bundle arguments = this.mFragmentMethod.getArguments();
        if (arguments == null) {
            return null;
        }
        if (PermissionVersion.isAndroid13()) {
            return arguments.getParcelableArrayList(REQUEST_PERMISSIONS, IPermission.class);
        }
        return arguments.getParcelableArrayList(REQUEST_PERMISSIONS);
    }

    int getPermissionRequestCode() {
        Bundle arguments = this.mFragmentMethod.getArguments();
        if (arguments == null) {
            return 0;
        }
        return arguments.getInt(REQUEST_CODE);
    }

    void sendTask(@NonNull Runnable runnable, long delayMillis) {
        PermissionTaskHandler.sendTask(runnable, this.mTaskToken, delayMillis);
    }

    void cancelTask() {
        PermissionTaskHandler.cancelTask(this.mTaskToken);
    }

    IStartActivityDelegate getStartActivityDelegate() {
        return this.mFragmentMethod;
    }

    abstract void startPermissionRequest(@NonNull Activity var1, @NonNull List<IPermission> var2, @IntRange(from=1L, to=65535L) int var3);

    @Override
    public void onFragmentResume() {
        if (!this.mRequestFlag) {
            this.mFragmentMethod.commitDetach();
            return;
        }
        if (this.mAlreadyRequest) {
            return;
        }
        this.mAlreadyRequest = true;
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        int requestCode = this.getPermissionRequestCode();
        if (requestCode <= 0) {
            return;
        }
        List<IPermission> permissions = this.getPermissionRequestList();
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        this.startPermissionRequest(activity, permissions, requestCode);
        OnPermissionFlowCallback callback = this.getCallBack();
        if (callback == null) {
            return;
        }
        callback.onRequestPermissionNow();
    }

    @Override
    public void onFragmentDestroy() {
        this.cancelTask();
        OnPermissionFlowCallback callBack = this.getCallBack();
        if (callBack != null) {
            callBack.onRequestPermissionAnomaly();
            this.setCallback(null);
        }
        if (this.mManualDetach) {
            return;
        }
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        ActivityOrientationManager.unlockActivityOrientation(activity);
    }

    protected void notificationPermissionCallback() {
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        this.sendTask(this::handlerPermissionCallback, PermissionApi.getMaxWaitTimeByPermissions((Context)activity, this.getPermissionRequestList()));
    }

    protected void handlerPermissionCallback() {
        if (this.isFragmentUnavailable()) {
            return;
        }
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        OnPermissionFlowCallback callback = this.getCallBack();
        this.setCallback(null);
        if (callback != null) {
            callback.onRequestPermissionFinish();
        }
        this.commitDetach();
    }
}

