/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.app.admin.DeviceAdminReceiver;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.BroadcastReceiverManifestInfo;
import com.hjq.permissions.manifest.node.IntentFilterManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class BindDeviceAdminPermission
extends SpecialPermission {
    public static final Parcelable.Creator<BindDeviceAdminPermission> CREATOR = new Parcelable.Creator<BindDeviceAdminPermission>(){

        public BindDeviceAdminPermission createFromParcel(Parcel source) {
            return new BindDeviceAdminPermission(source);
        }

        public BindDeviceAdminPermission[] newArray(int size) {
            return new BindDeviceAdminPermission[size];
        }
    };
    @NonNull
    private final String mDeviceAdminReceiverClassName;
    @Nullable
    private final String mExtraAddExplanation;

    public BindDeviceAdminPermission(@NonNull Class<? extends DeviceAdminReceiver> deviceAdminReceiverClass, @Nullable String extraAddExplanation) {
        this(deviceAdminReceiverClass.getName(), extraAddExplanation);
    }

    public BindDeviceAdminPermission(@NonNull String deviceAdminReceiverClassName, @Nullable String extraAddExplanation) {
        this.mDeviceAdminReceiverClassName = deviceAdminReceiverClassName;
        this.mExtraAddExplanation = extraAddExplanation;
    }

    private BindDeviceAdminPermission(Parcel in) {
        this(in.readString(), in.readString());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mDeviceAdminReceiverClassName);
        dest.writeString(this.mExtraAddExplanation);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return "android.permission.BIND_DEVICE_ADMIN";
    }

    @Override
    public int getFromAndroidVersion() {
        return 8;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        DevicePolicyManager devicePolicyManager = PermissionVersion.isAndroid6() ? (DevicePolicyManager)context.getSystemService(DevicePolicyManager.class) : (DevicePolicyManager)context.getSystemService("device_policy");
        if (devicePolicyManager == null) {
            return false;
        }
        return devicePolicyManager.isAdminActive(new ComponentName(context, this.mDeviceAdminReceiverClassName));
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2);
        Intent intent = new Intent("android.app.action.ADD_DEVICE_ADMIN");
        intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)new ComponentName(context, this.mDeviceAdminReceiverClassName));
        intent.putExtra("android.app.extra.ADD_EXPLANATION", this.mExtraAddExplanation);
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    public void checkCompliance(@NonNull Activity activity, @NonNull List<IPermission> requestList, @Nullable AndroidManifestInfo androidManifestInfo) {
        super.checkCompliance(activity, requestList, androidManifestInfo);
        if (TextUtils.isEmpty((CharSequence)this.mDeviceAdminReceiverClassName)) {
            throw new IllegalArgumentException("Pass the BroadcastReceiverClass parameter as empty");
        }
        if (!PermissionUtils.isClassExist(this.mDeviceAdminReceiverClassName)) {
            throw new IllegalArgumentException("The passed-in " + this.mDeviceAdminReceiverClassName + " is an invalid class");
        }
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, androidManifestInfo, permissionInfoList, currentPermissionInfo);
        List<BroadcastReceiverManifestInfo> broadcastReceiverManifestInfoList = androidManifestInfo.broadcastReceiverManifestInfoList;
        for (BroadcastReceiverManifestInfo broadcastReceiverManifestInfo : broadcastReceiverManifestInfoList) {
            if (broadcastReceiverManifestInfo == null || !PermissionUtils.reverseEqualsString(this.mDeviceAdminReceiverClassName, broadcastReceiverManifestInfo.name)) continue;
            if (broadcastReceiverManifestInfo.permission == null || !PermissionUtils.equalsPermission((IPermission)this, broadcastReceiverManifestInfo.permission)) {
                throw new IllegalArgumentException("Please register permission node in the AndroidManifest.xml file, for example: <receiver android:name=\"" + this.mDeviceAdminReceiverClassName + "\" android:permission=\"" + this.getPermissionName() + "\" />");
            }
            String action = "android.app.action.DEVICE_ADMIN_ENABLED";
            boolean registeredDeviceAdminReceiverAction = false;
            List<IntentFilterManifestInfo> intentFilterManifestInfoList = broadcastReceiverManifestInfo.intentFilterManifestInfoList;
            if (intentFilterManifestInfoList != null) {
                for (IntentFilterManifestInfo intentFilterManifestInfo : intentFilterManifestInfoList) {
                    if (!intentFilterManifestInfo.actionList.contains(action)) continue;
                    registeredDeviceAdminReceiverAction = true;
                    break;
                }
            }
            if (registeredDeviceAdminReceiverAction) {
                return;
            }
            String xmlCode = "\t\t<intent-filter>\n\t\t    <action android:name=\"" + action + "\" />\n\t\t</intent-filter>";
            throw new IllegalArgumentException("Please add an intent filter for \"" + this.mDeviceAdminReceiverClassName + "\" in the AndroidManifest.xml file.\n" + xmlCode);
        }
        throw new IllegalArgumentException("The \"" + this.mDeviceAdminReceiverClassName + "\" component is not registered in the AndroidManifest.xml file");
    }

    @NonNull
    public String getDeviceAdminReceiverClassName() {
        return this.mDeviceAdminReceiverClassName;
    }

    @Nullable
    public String getExtraAddExplanation() {
        return this.mExtraAddExplanation;
    }
}

