/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.hjq.permissions.core.RequestPermissionDelegateImpl;
import com.hjq.permissions.fragment.IFragmentMethod;
import com.hjq.permissions.manager.AlreadyRequestPermissionsManager;
import com.hjq.permissions.manager.PermissionRequestCodeManager;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class RequestPermissionDelegateImplByDangerous
extends RequestPermissionDelegateImpl {
    public RequestPermissionDelegateImplByDangerous(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        super(fragmentMethod);
    }

    @Override
    void startPermissionRequest(@NonNull Activity activity, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (!PermissionVersion.isAndroid6()) {
            this.sendTask(this::handlerPermissionCallback, 0L);
            return;
        }
        this.requestPermissions(PermissionUtils.convertPermissionArray(permissions), requestCode);
        AlreadyRequestPermissionsManager.addAlreadyRequestPermissions(permissions);
    }

    @Override
    public void onFragmentRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode != this.getPermissionRequestCode()) {
            return;
        }
        PermissionRequestCodeManager.releaseRequestCode(requestCode);
        this.notificationPermissionCallback();
    }
}

