/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.DefaultPermissionDescription;
import com.hjq.permissions.DefaultPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactoryByApp;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactoryBySupport;
import com.hjq.permissions.manifest.AndroidManifestParser;
import com.hjq.permissions.permission.PermissionType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.start.StartActivityAgent;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionChecker;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static Class<? extends OnPermissionInterceptor> sPermissionInterceptorClass;
    private static Class<? extends OnPermissionDescription> sPermissionDescriptionClass;
    private static Boolean sCheckMode;
    @NonNull
    private final List<IPermission> mPermissions = new ArrayList<IPermission>();
    @Nullable
    private final Context mContext;
    @Nullable
    private Fragment mAppFragment;
    @Nullable
    private android.support.v4.app.Fragment mSupportFragment;
    @Nullable
    private OnPermissionInterceptor mPermissionInterceptor;
    @Nullable
    private OnPermissionDescription mPermissionDescription;
    @Nullable
    private Boolean mCheckMode;

    public static XXPermissions with(@NonNull Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(@NonNull Fragment appFragment) {
        return new XXPermissions(appFragment);
    }

    public static XXPermissions with(@NonNull android.support.v4.app.Fragment supportFragment) {
        return new XXPermissions(supportFragment);
    }

    public static void setCheckMode(boolean checkMode) {
        sCheckMode = checkMode;
    }

    public static void setPermissionInterceptor(Class<? extends OnPermissionInterceptor> clazz) {
        sPermissionInterceptorClass = clazz;
    }

    @NonNull
    public static OnPermissionInterceptor getPermissionInterceptor() {
        if (sPermissionInterceptorClass != null) {
            try {
                return sPermissionInterceptorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultPermissionInterceptor();
    }

    public static void setPermissionDescription(Class<? extends OnPermissionDescription> clazz) {
        sPermissionDescriptionClass = clazz;
    }

    @NonNull
    public static OnPermissionDescription getPermissionDescription() {
        if (sPermissionDescriptionClass != null) {
            try {
                return sPermissionDescriptionClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultPermissionDescription();
    }

    private XXPermissions(@NonNull Context context) {
        this.mContext = context;
    }

    private XXPermissions(@NonNull Fragment appFragment) {
        this.mAppFragment = appFragment;
        this.mContext = appFragment.getActivity();
    }

    private XXPermissions(@NonNull android.support.v4.app.Fragment supportFragment) {
        this.mSupportFragment = supportFragment;
        this.mContext = supportFragment.getActivity();
    }

    public XXPermissions permission(@NonNull IPermission permission) {
        this.mPermissions.remove(permission);
        this.mPermissions.add(permission);
        return this;
    }

    public XXPermissions permissions(@NonNull List<IPermission> permissions) {
        if (permissions.isEmpty()) {
            return this;
        }
        for (int i = 0; i < permissions.size(); ++i) {
            this.permission(permissions.get(i));
        }
        return this;
    }

    public XXPermissions permissions(@NonNull IPermission[] permissions) {
        return this.permissions(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions interceptor(@Nullable OnPermissionInterceptor permissionInterceptor) {
        this.mPermissionInterceptor = permissionInterceptor;
        return this;
    }

    public XXPermissions description(@Nullable OnPermissionDescription permissionDescription) {
        this.mPermissionDescription = permissionDescription;
        return this;
    }

    public XXPermissions unchecked() {
        this.mCheckMode = false;
        return this;
    }

    public void request(@Nullable OnPermissionCallback callback) {
        if (this.mContext == null) {
            return;
        }
        if (this.mPermissionInterceptor == null) {
            this.mPermissionInterceptor = XXPermissions.getPermissionInterceptor();
        }
        if (this.mPermissionDescription == null) {
            this.mPermissionDescription = XXPermissions.getPermissionDescription();
        }
        Context context = this.mContext;
        Fragment appFragment = this.mAppFragment;
        android.support.v4.app.Fragment supportFragment = this.mSupportFragment;
        OnPermissionInterceptor permissionInterceptor = this.mPermissionInterceptor;
        OnPermissionDescription permissionDescription = this.mPermissionDescription;
        ArrayList<IPermission> permissions = new ArrayList<IPermission>(this.mPermissions);
        Activity activity = PermissionUtils.findActivity(context);
        if (this.isCheckMode(context)) {
            PermissionChecker.checkActivityStatus(activity);
            if (appFragment != null) {
                PermissionChecker.checkAppFragmentStatus(appFragment);
            } else if (supportFragment != null) {
                PermissionChecker.checkSupportFragmentStatus(supportFragment);
            }
            PermissionChecker.checkPermissionList(activity, permissions, AndroidManifestParser.getAndroidManifestInfo(context));
        }
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        PermissionApi.addOldPermissionsByNewPermissions((Context)activity, permissions);
        if (PermissionApi.isGrantedPermissions(context, permissions)) {
            permissionInterceptor.grantedPermissionRequest(activity, permissions, permissions, true, callback);
            permissionInterceptor.finishPermissionRequest(activity, permissions, true, callback);
            return;
        }
        if (appFragment != null && PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (supportFragment != null && PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, supportFragment, appFragment);
        permissionInterceptor.launchPermissionRequest(activity, permissions, fragmentFactory, permissionDescription, callback);
    }

    public boolean revokeOnKill() {
        Context context = this.mContext;
        if (context == null) {
            return false;
        }
        List<IPermission> permissions = this.mPermissions;
        if (permissions.isEmpty()) {
            return false;
        }
        if (!PermissionVersion.isAndroid13()) {
            return false;
        }
        try {
            if (permissions.size() == 1) {
                context.revokeSelfPermissionOnKill(permissions.get(0).getPermissionName());
            } else {
                context.revokeSelfPermissionsOnKill(PermissionUtils.convertPermissionList(permissions));
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            if (this.isCheckMode(context)) {
                throw e;
            }
            e.printStackTrace();
            return false;
        }
    }

    private boolean isCheckMode(@NonNull Context context) {
        if (this.mCheckMode == null) {
            if (sCheckMode == null) {
                sCheckMode = PermissionUtils.isDebugMode(context);
            }
            this.mCheckMode = sCheckMode;
        }
        return this.mCheckMode;
    }

    public static boolean isGrantedPermission(@NonNull Context context, @NonNull IPermission permission) {
        return permission.isGrantedPermission(context);
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.isGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.isGrantedPermissions(context, permissions);
    }

    public static List<IPermission> getGrantedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.getGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<IPermission> getGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.getGrantedPermissions(context, permissions);
    }

    public static List<IPermission> getDeniedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<IPermission> getDeniedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.getDeniedPermissions(context, permissions);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull IPermission permission2) {
        return PermissionUtils.equalsPermission(permission1, permission2);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull String permission2) {
        return PermissionUtils.equalsPermission(permission1, permission2);
    }

    public static boolean equalsPermission(@NonNull String permissionName1, @NonNull String permission2) {
        return PermissionUtils.equalsPermission(permissionName1, permission2);
    }

    public static boolean containsPermission(@NonNull List<IPermission> permissions, @NonNull IPermission permission) {
        return PermissionUtils.containsPermission(permissions, permission);
    }

    public static boolean containsPermission(@NonNull List<IPermission> permissions, @NonNull String permissionName) {
        return PermissionUtils.containsPermission(permissions, permissionName);
    }

    public static boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull IPermission permission) {
        return permission.isDoNotAskAgainPermission(activity);
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull IPermission[] permissions) {
        return XXPermissions.isDoNotAskAgainPermissions(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<IPermission> permissions) {
        return PermissionApi.isDoNotAskAgainPermissions(activity, permissions);
    }

    public static void startPermissionActivity(@NonNull Context context) {
        XXPermissions.startPermissionActivity(context, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Context context, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, @NonNull List<IPermission> permissions) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, permissions);
            return;
        }
        StartActivityAgent.startActivity(context, PermissionApi.getBestPermissionSettingIntent(context, permissions, true));
    }

    public static void startPermissionActivity(@NonNull Activity activity) {
        XXPermissions.startPermissionActivity(activity, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Activity activity, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(activity, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult(activity, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull IPermission permission, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(activity, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> {
            if (PermissionUtils.isActivityUnavailable(activity)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment) {
        XXPermissions.startPermissionActivity(appFragment, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(appFragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        Activity activity = appFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(appFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        StartActivityAgent.startActivityForResult(appFragment, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull IPermission permission, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<IPermission> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        Activity activity = appFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(appFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, appFragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> {
            if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment) {
        XXPermissions.startPermissionActivity(supportFragment, new ArrayList<IPermission>());
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(supportFragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        FragmentActivity activity = supportFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(supportFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        StartActivityAgent.startActivityForResult(supportFragment, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull IPermission permission, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<IPermission> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        FragmentActivity activity = supportFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(supportFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory((Activity)activity, supportFragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> XXPermissions.lambda$startPermissionActivity$2((Activity)activity, supportFragment, permissions, callback));
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, null);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable android.support.v4.app.Fragment supportFragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, supportFragment, null);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable Fragment appFragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, appFragment);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable android.support.v4.app.Fragment supportFragment, @Nullable Fragment appFragment) {
        PermissionFragmentFactory fragmentFactory;
        if (supportFragment != null) {
            fragmentFactory = new PermissionFragmentFactoryBySupport(supportFragment.getActivity(), supportFragment.getChildFragmentManager());
        } else if (appFragment != null) {
            fragmentFactory = new PermissionFragmentFactoryByApp(appFragment.getActivity(), appFragment.getChildFragmentManager());
        } else if (activity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)activity;
            fragmentFactory = new PermissionFragmentFactoryBySupport(fragmentActivity, fragmentActivity.getSupportFragmentManager());
        } else {
            fragmentFactory = new PermissionFragmentFactoryByApp(activity, activity.getFragmentManager());
        }
        return fragmentFactory;
    }

    private static void dispatchPermissionPageCallback(@NonNull Context context, @NonNull List<IPermission> permissions, @Nullable OnPermissionPageCallback callback) {
        if (callback == null) {
            return;
        }
        if (XXPermissions.isGrantedPermissions(context, permissions)) {
            callback.onGranted();
        } else {
            callback.onDenied();
        }
    }

    private static /* synthetic */ void lambda$startPermissionActivity$2(Activity activity, android.support.v4.app.Fragment supportFragment, List permissions, OnPermissionPageCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
    }
}

