/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionVersion;
import com.hjq.permissions.tools.PhoneRomUtils;
import java.util.ArrayList;
import java.util.List;

public final class SystemAlertWindowPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.SYSTEM_ALERT_WINDOW";
    public static final Parcelable.Creator<SystemAlertWindowPermission> CREATOR = new Parcelable.Creator<SystemAlertWindowPermission>(){

        public SystemAlertWindowPermission createFromParcel(Parcel source) {
            return new SystemAlertWindowPermission(source);
        }

        public SystemAlertWindowPermission[] newArray(int size) {
            return new SystemAlertWindowPermission[size];
        }
    };
    private static final String OP_SYSTEM_ALERT_WINDOW_FIELD_NAME = "OP_SYSTEM_ALERT_WINDOW";
    private static final int OP_SYSTEM_ALERT_WINDOW_DEFAULT_VALUE = 24;

    public SystemAlertWindowPermission() {
    }

    private SystemAlertWindowPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 17;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        if (!PermissionVersion.isAndroid4_4()) {
            return true;
        }
        return SystemAlertWindowPermission.checkOpPermission(context, OP_SYSTEM_ALERT_WINDOW_FIELD_NAME, 24, true);
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(7);
        if (PermissionVersion.isAndroid6()) {
            if (PermissionVersion.isAndroid11() && !PhoneRomUtils.isHyperOs() && PhoneRomUtils.isMiui() && PhoneRomUtils.isXiaomiSystemOptimization()) {
                intent = PermissionSettingPage.getXiaoMiApplicationPermissionPageIntent(context);
                intentList.add(intent);
            }
            intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intentList.add(intent);
        } else if (PhoneRomUtils.isEmui()) {
            Intent addViewMonitorActivityIntent = new Intent();
            addViewMonitorActivityIntent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.addviewmonitor.AddViewMonitorActivity");
            Intent notificationManagementActivityIntent = new Intent();
            notificationManagementActivityIntent.setClassName("com.huawei.systemmanager", "com.huawei.notificationmanager.ui.NotificationManagmentActivity");
            String romVersionName = PhoneRomUtils.getRomVersionName();
            if (romVersionName == null) {
                romVersionName = "";
            }
            if (romVersionName.startsWith("3.0")) {
                intentList.add(notificationManagementActivityIntent);
                intentList.add(addViewMonitorActivityIntent);
            } else {
                intentList.add(addViewMonitorActivityIntent);
                intentList.add(notificationManagementActivityIntent);
            }
            intentList.addAll(PermissionSettingPage.getHuaWeiMobileManagerAppIntent(context));
        } else if (PhoneRomUtils.isMiui()) {
            if (PhoneRomUtils.isXiaomiSystemOptimization()) {
                intent = PermissionSettingPage.getXiaoMiApplicationPermissionPageIntent(context);
                intentList.add(intent);
                intentList.addAll(PermissionSettingPage.getXiaoMiMobileManagerAppIntent(context));
            }
        } else if (PhoneRomUtils.isColorOs()) {
            intent = new Intent();
            intent.setClassName("com.oppo.safe", "com.oppo.safe.permission.PermissionTopActivity");
            intentList.add(intent);
            intentList.addAll(PermissionSettingPage.getOppoSafeCenterAppIntent(context));
        } else if (PhoneRomUtils.isOriginOs()) {
            intentList.addAll(PermissionSettingPage.getVivoMobileManagerAppIntent(context));
        } else if (PhoneRomUtils.isOneUi()) {
            intent = PermissionSettingPage.getOneUiPermissionPageIntent(context);
            intentList.add(intent);
        } else if (PhoneRomUtils.isSmartisanOS() && !PermissionVersion.isAndroid5_1()) {
            intentList.addAll(PermissionSettingPage.getSmartisanPermissionPageIntent());
            intentList.addAll(PermissionSettingPage.getSmartisanSecurityCenterAppIntent(context));
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = SystemAlertWindowPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = SystemAlertWindowPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

