/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.core.RequestPermissionDelegateImpl;
import com.hjq.permissions.fragment.IFragmentMethod;
import com.hjq.permissions.manager.PermissionRequestCodeManager;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.start.StartActivityAgent;
import com.hjq.permissions.tools.PermissionApi;
import java.util.List;

public final class RequestPermissionDelegateImplBySpecial
extends RequestPermissionDelegateImpl {
    private int mIgnoreActivityResultCount = 0;

    public RequestPermissionDelegateImplBySpecial(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        super(fragmentMethod);
    }

    @Override
    void startPermissionRequest(@NonNull Activity activity, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult((Context)activity, this.getStartActivityDelegate(), PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions), requestCode, () -> ++this.mIgnoreActivityResultCount);
    }

    @Override
    public void onFragmentActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != this.getPermissionRequestCode()) {
            return;
        }
        if (this.mIgnoreActivityResultCount > 0) {
            --this.mIgnoreActivityResultCount;
            return;
        }
        PermissionRequestCodeManager.releaseRequestCode(requestCode);
        this.notificationPermissionCallback();
    }
}

