/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.ActivityOrientationControl;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionFragmentFactory;
import com.hjq.permissions.PermissionGroupType;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionTaskHandler;
import com.hjq.permissions.PermissionType;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class RequestPermissionLogicPresenter {
    @NonNull
    private final Activity mActivity;
    @NonNull
    private final List<String> mRequestPermissions;
    @NonNull
    private final PermissionFragmentFactory<?, ?> mFragmentFactory;
    @NonNull
    private final OnPermissionInterceptor mPermissionInterceptor;
    @NonNull
    private final OnPermissionDescription mPermissionDescription;
    @Nullable
    private final OnPermissionCallback mCallBack;

    RequestPermissionLogicPresenter(@NonNull Activity activity, @NonNull List<String> requestPermissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, @NonNull OnPermissionInterceptor permissionInterceptor, @NonNull OnPermissionDescription permissionDescription, @Nullable OnPermissionCallback callback) {
        this.mActivity = activity;
        this.mRequestPermissions = requestPermissions;
        this.mFragmentFactory = fragmentFactory;
        this.mPermissionInterceptor = permissionInterceptor;
        this.mPermissionDescription = permissionDescription;
        this.mCallBack = callback;
    }

    void request() {
        if (this.mRequestPermissions.isEmpty()) {
            return;
        }
        List<List<String>> unauthorizedPermissions = RequestPermissionLogicPresenter.getUnauthorizedPermissions(this.mActivity, this.mRequestPermissions);
        if (unauthorizedPermissions.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Iterator<List<String>> iterator = unauthorizedPermissions.iterator();
        List<String> firstPermissions = null;
        while (iterator.hasNext() && (firstPermissions == null || firstPermissions.isEmpty())) {
            firstPermissions = iterator.next();
        }
        if (firstPermissions == null || firstPermissions.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Activity activity = this.mActivity;
        final PermissionFragmentFactory<?, ?> fragmentFactory = this.mFragmentFactory;
        final OnPermissionDescription permissionDescription = this.mPermissionDescription;
        RequestPermissionLogicPresenter.requestPermissions(activity, firstPermissions, fragmentFactory, permissionDescription, new Runnable(){

            @Override
            public void run() {
                List<String> foregroundPermissions;
                List nextPermissions = null;
                while (iterator.hasNext() && (nextPermissions == null || nextPermissions.isEmpty())) {
                    nextPermissions = (List)iterator.next();
                }
                if (nextPermissions == null || nextPermissions.isEmpty()) {
                    RequestPermissionLogicPresenter.this.postDelayedHandlerRequestPermissionsResult();
                    return;
                }
                if (nextPermissions.size() == 1 && PermissionApi.isBackgroundPermission((String)nextPermissions.get(0)) && (foregroundPermissions = PermissionHelper.queryForegroundPermissionByBackgroundPermission((String)nextPermissions.get(0))) != null && !foregroundPermissions.isEmpty() && !PermissionApi.isGrantedPermissions((Context)activity, foregroundPermissions)) {
                    this.run();
                    return;
                }
                List finalPermissions = nextPermissions;
                int maxWaitTimeByPermissions = PermissionHelper.getMaxIntervalTimeByPermissions(nextPermissions);
                if (maxWaitTimeByPermissions == 0) {
                    RequestPermissionLogicPresenter.requestPermissions(activity, finalPermissions, fragmentFactory, permissionDescription, this);
                } else {
                    PermissionTaskHandler.sendTask(() -> RequestPermissionLogicPresenter.requestPermissions(activity, finalPermissions, fragmentFactory, permissionDescription, this), maxWaitTimeByPermissions);
                }
            }
        });
    }

    private static List<List<String>> getUnauthorizedPermissions(@NonNull Activity activity, @NonNull List<String> requestPermissions) {
        ArrayList<List<String>> unauthorizedPermissions = new ArrayList<List<String>>(requestPermissions.size());
        ArrayList<String> alreadyDonePermissions = new ArrayList<String>(requestPermissions.size());
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.containsPermission(alreadyDonePermissions, permission2)) continue;
            alreadyDonePermissions.add(permission2);
            if (PermissionApi.isGrantedPermission((Context)activity, permission2) || AndroidVersionTools.getCurrentAndroidVersionCode() < PermissionHelper.findAndroidVersionByPermission(permission2)) continue;
            if (PermissionApi.isSpecialPermission(permission2)) {
                unauthorizedPermissions.add(PermissionUtils.asArrayList(permission2));
                continue;
            }
            PermissionGroupType permissionGroupType = PermissionHelper.queryDangerousPermissionGroupType(permission2);
            if (permissionGroupType == null) {
                unauthorizedPermissions.add(PermissionUtils.asArrayList(permission2));
                continue;
            }
            ArrayList<String> dangerousPermissions = new ArrayList<String>(PermissionHelper.getDangerousPermissionGroup(permissionGroupType));
            Iterator iterator = dangerousPermissions.iterator();
            while (iterator.hasNext()) {
                String dangerousPermission = (String)iterator.next();
                if (PermissionUtils.containsPermission(alreadyDonePermissions, dangerousPermission)) continue;
                alreadyDonePermissions.add(dangerousPermission);
                if (PermissionHelper.findAndroidVersionByPermission(dangerousPermission) > AndroidVersionTools.getCurrentAndroidVersionCode()) {
                    iterator.remove();
                    continue;
                }
                if (PermissionUtils.containsPermission(requestPermissions, dangerousPermission)) continue;
                iterator.remove();
            }
            if (dangerousPermissions.isEmpty() || PermissionApi.isGrantedPermissions((Context)activity, dangerousPermissions)) continue;
            String backgroundPermission = PermissionHelper.getBackgroundPermissionByGroup(dangerousPermissions);
            if (TextUtils.isEmpty((CharSequence)backgroundPermission)) {
                unauthorizedPermissions.add(dangerousPermissions);
                continue;
            }
            ArrayList<String> foregroundPermissions = new ArrayList<String>(dangerousPermissions);
            foregroundPermissions.remove(backgroundPermission);
            if (!foregroundPermissions.isEmpty() && !PermissionApi.isGrantedPermissions((Context)activity, foregroundPermissions)) {
                unauthorizedPermissions.add(foregroundPermissions);
            }
            unauthorizedPermissions.add(PermissionUtils.asArrayList(backgroundPermission));
        }
        return unauthorizedPermissions;
    }

    private static void requestPermissions(final @NonNull Activity activity, final List<String> permissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, final @NonNull OnPermissionDescription permissionDescription, final @NonNull Runnable finishRunnable) {
        PermissionType permissionType;
        if (permissions.isEmpty()) {
            finishRunnable.run();
            return;
        }
        PermissionType permissionType2 = permissionType = PermissionApi.areAllDangerousPermission(permissions) ? PermissionType.DANGEROUS : PermissionType.SPECIAL;
        if (permissionType == PermissionType.DANGEROUS && !AndroidVersionTools.isAndroid6()) {
            finishRunnable.run();
            return;
        }
        Runnable continueRequestRunnable = () -> fragmentFactory.createAndCommitFragment(permissions, permissionType, new OnPermissionFlowCallback(){

            @Override
            public void onRequestPermissionNow() {
                permissionDescription.onRequestPermissionStart(activity, permissions);
            }

            @Override
            public void onRequestPermissionFinish() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
                finishRunnable.run();
            }

            @Override
            public void onRequestPermissionAnomaly() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
            }
        });
        permissionDescription.askWhetherRequestPermission(activity, permissions, continueRequestRunnable, finishRunnable);
    }

    private void postDelayedHandlerRequestPermissionsResult() {
        PermissionTaskHandler.sendTask(this::handlePermissionRequestResult, 100L);
    }

    private void postDelayedUnlockActivityOrientation(@NonNull Activity activity) {
        PermissionTaskHandler.sendTask(() -> ActivityOrientationControl.unlockActivityOrientation(activity), 100L);
    }

    private void handlePermissionRequestResult() {
        OnPermissionCallback callback = this.mCallBack;
        OnPermissionInterceptor interceptor = this.mPermissionInterceptor;
        List<String> requestPermissions = this.mRequestPermissions;
        Activity activity = this.mActivity;
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        ArrayList<String> grantedPermissions = new ArrayList<String>(requestPermissions.size());
        ArrayList<String> deniedPermissions = new ArrayList<String>(requestPermissions.size());
        for (String permission2 : requestPermissions) {
            if (PermissionApi.isGrantedPermission((Context)activity, permission2, false)) {
                grantedPermissions.add(permission2);
                continue;
            }
            deniedPermissions.add(permission2);
        }
        if (grantedPermissions.size() == requestPermissions.size()) {
            interceptor.grantedPermissionRequest(activity, requestPermissions, grantedPermissions, true, callback);
            interceptor.finishPermissionRequest(activity, requestPermissions, false, callback);
            this.postDelayedUnlockActivityOrientation(activity);
            return;
        }
        interceptor.deniedPermissionRequest(activity, requestPermissions, deniedPermissions, PermissionApi.isDoNotAskAgainPermissions(activity, deniedPermissions), callback);
        if (!grantedPermissions.isEmpty()) {
            interceptor.grantedPermissionRequest(activity, requestPermissions, grantedPermissions, false, callback);
        }
        interceptor.finishPermissionRequest(activity, requestPermissions, false, callback);
        this.postDelayedUnlockActivityOrientation(activity);
    }
}

