/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.IFragmentMethod;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.PermissionActivityIntentHandler;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionRequestCodeManager;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.RequestPermissionDelegateImpl;
import java.util.List;

final class RequestPermissionDelegateImplBySpecial
extends RequestPermissionDelegateImpl {
    RequestPermissionDelegateImplBySpecial(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        super(fragmentMethod);
    }

    @Override
    void startPermissionRequest(@NonNull Activity activity, @NonNull List<String> permissions, int requestCode) {
        PermissionActivityIntentHandler.startActivityForResult(this.getStartActivityDelegate(), PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions), requestCode);
    }

    @Override
    public void onFragmentActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onFragmentActivityResult(requestCode, resultCode, data);
        if (requestCode != this.getPermissionRequestCode()) {
            return;
        }
        PermissionRequestCodeManager.releaseRequestCode(requestCode);
        List<String> permissions = this.getPermissionRequestList();
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        this.sendTask(this::dispatchPermissionCallback, PermissionHelper.getMaxWaitTimeByPermissions(permissions));
    }

    private void dispatchPermissionCallback() {
        if (this.isFragmentUnavailable()) {
            return;
        }
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        OnPermissionFlowCallback callback = this.getCallBack();
        this.setCallback(null);
        if (callback != null) {
            callback.onRequestPermissionFinish();
        }
        this.commitDetach();
    }
}

