/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.ActivityOrientationControl;
import com.hjq.permissions.IFragmentCallback;
import com.hjq.permissions.IFragmentMethod;
import com.hjq.permissions.IStartActivityDelegate;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.PermissionTaskHandler;
import com.hjq.permissions.PermissionUtils;
import java.util.List;

abstract class RequestPermissionDelegateImpl
implements IFragmentCallback {
    static final String REQUEST_PERMISSIONS = "request_permissions";
    static final String REQUEST_CODE = "request_code";
    @NonNull
    private final Object mTaskToken = new Object();
    private boolean mRequestFlag;
    private boolean mAlreadyRequest;
    private boolean mManualDetach;
    @NonNull
    private final IFragmentMethod<?, ?> mFragmentMethod;
    @Nullable
    private OnPermissionFlowCallback mCallBack;

    RequestPermissionDelegateImpl(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        this.mFragmentMethod = fragmentMethod;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    void setCallback(@Nullable OnPermissionFlowCallback callback) {
        this.mCallBack = callback;
    }

    @Nullable
    OnPermissionFlowCallback getCallBack() {
        return this.mCallBack;
    }

    @Nullable
    Activity getActivity() {
        return this.mFragmentMethod.getActivity();
    }

    void commitDetach() {
        this.mManualDetach = true;
        this.mFragmentMethod.commitDetach();
    }

    boolean isFragmentUnavailable() {
        return !this.mFragmentMethod.isAdded() || this.mFragmentMethod.isRemoving();
    }

    void requestPermissions(@NonNull String[] permissions, int requestCode) {
        this.mFragmentMethod.requestPermissions(permissions, requestCode);
    }

    @Nullable
    List<String> getPermissionRequestList() {
        Bundle arguments = this.mFragmentMethod.getArguments();
        if (arguments == null) {
            return null;
        }
        return arguments.getStringArrayList(REQUEST_PERMISSIONS);
    }

    int getPermissionRequestCode() {
        Bundle arguments = this.mFragmentMethod.getArguments();
        if (arguments == null) {
            return 0;
        }
        return arguments.getInt(REQUEST_CODE);
    }

    void sendTask(@NonNull Runnable runnable, long delayMillis) {
        PermissionTaskHandler.sendTask(runnable, this.mTaskToken, delayMillis);
    }

    void cancelTask() {
        PermissionTaskHandler.cancelTask(this.mTaskToken);
    }

    IStartActivityDelegate getStartActivityDelegate() {
        return this.mFragmentMethod;
    }

    abstract void startPermissionRequest(@NonNull Activity var1, @NonNull List<String> var2, int var3);

    @Override
    public void onFragmentResume() {
        if (!this.mRequestFlag) {
            this.mFragmentMethod.commitDetach();
            return;
        }
        if (this.mAlreadyRequest) {
            return;
        }
        this.mAlreadyRequest = true;
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        int requestCode = this.getPermissionRequestCode();
        if (requestCode <= 0) {
            return;
        }
        List<String> permissions = this.getPermissionRequestList();
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        this.startPermissionRequest(activity, permissions, requestCode);
        ActivityOrientationControl.lockActivityOrientation(activity);
        OnPermissionFlowCallback callback = this.getCallBack();
        if (callback == null) {
            return;
        }
        callback.onRequestPermissionNow();
    }

    @Override
    public void onFragmentDestroy() {
        this.cancelTask();
        OnPermissionFlowCallback callBack = this.getCallBack();
        if (callBack != null) {
            callBack.onRequestPermissionAnomaly();
            this.setCallback(null);
        }
        if (this.mManualDetach) {
            return;
        }
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        ActivityOrientationControl.unlockActivityOrientation(activity);
    }
}

