/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.PermissionGroupType;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PermissionHelper {
    private static final List<String> SPECIAL_PERMISSION_LIST = new ArrayList<String>(12);
    private static final Map<String, Integer> PERMISSION_VERSION_MAP = new HashMap<String, Integer>(53);
    private static final List<String> VIRTUAL_PERMISSION_LIST = new ArrayList<String>(4);
    private static final Map<String, String[]> NEW_AND_OLD_PERMISSION_MAP = new HashMap<String, String[]>(10);
    private static final Map<String, List<String>> BACKGROUND_PERMISSION_MAP = new HashMap<String, List<String>>(2);
    private static final Map<PermissionGroupType, List<String>> DANGEROUS_PERMISSION_GROUP_MAP = new EnumMap<PermissionGroupType, List<String>>(PermissionGroupType.class);
    private static final Map<String, PermissionGroupType> DANGEROUS_PERMISSION_GROUP_TYPE_MAP = new HashMap<String, PermissionGroupType>(25);
    private static final List<String> LOW_LEVEL_PERMISSION_LIST = new ArrayList<String>(3);
    private static final Map<String, Integer> PERMISSIONS_REQUEST_INTERVAL_TIME = new HashMap<String, Integer>(2);
    private static final Map<String, Integer> PERMISSIONS_RESULT_WAIT_TIME = new HashMap<String, Integer>(25);

    PermissionHelper() {
    }

    static boolean isSpecialPermission(@NonNull String permission2) {
        return PermissionUtils.containsPermission(SPECIAL_PERMISSION_LIST, permission2);
    }

    static int findAndroidVersionByPermission(@NonNull String permission2) {
        Integer androidVersion = PERMISSION_VERSION_MAP.get(permission2);
        if (androidVersion == null) {
            return 0;
        }
        return androidVersion;
    }

    static boolean isVirtualPermission(@NonNull String permission2) {
        return PermissionUtils.containsPermission(VIRTUAL_PERMISSION_LIST, permission2);
    }

    @Nullable
    static String[] queryOldPermissionByNewPermission(@NonNull String permission2) {
        return NEW_AND_OLD_PERMISSION_MAP.get(permission2);
    }

    @Nullable
    static PermissionGroupType queryDangerousPermissionGroupType(@NonNull String permission2) {
        return DANGEROUS_PERMISSION_GROUP_TYPE_MAP.get(permission2);
    }

    @Nullable
    static List<String> getDangerousPermissionGroup(@NonNull PermissionGroupType permissionsGroupType) {
        return DANGEROUS_PERMISSION_GROUP_MAP.get((Object)permissionsGroupType);
    }

    static boolean isBackgroundPermission(String permission2) {
        return BACKGROUND_PERMISSION_MAP.containsKey(permission2);
    }

    @Nullable
    static List<String> queryForegroundPermissionByBackgroundPermission(String permission2) {
        return BACKGROUND_PERMISSION_MAP.get(permission2);
    }

    @Nullable
    static String getBackgroundPermissionByGroup(List<String> permissions) {
        for (String permission2 : permissions) {
            if (!PermissionHelper.isBackgroundPermission(permission2)) continue;
            return permission2;
        }
        return null;
    }

    @NonNull
    static List<String> getLowLevelPermissions() {
        return LOW_LEVEL_PERMISSION_LIST;
    }

    static int getMaxIntervalTimeByPermissions(@NonNull List<String> permissions) {
        int maxWaitTime = 0;
        for (String permission2 : permissions) {
            Integer time = PERMISSIONS_REQUEST_INTERVAL_TIME.get(permission2);
            if (time == null) continue;
            maxWaitTime = Math.max(maxWaitTime, time);
        }
        return maxWaitTime;
    }

    static int getMaxWaitTimeByPermissions(@NonNull List<String> permissions) {
        int maxWaitTime = 0;
        for (String permission2 : permissions) {
            Integer time = PERMISSIONS_RESULT_WAIT_TIME.get(permission2);
            if (time == null) continue;
            maxWaitTime = Math.max(maxWaitTime, time);
        }
        return maxWaitTime;
    }

    /*
     * WARNING - void declaration
     */
    static {
        SPECIAL_PERMISSION_LIST.add("android.permission.SCHEDULE_EXACT_ALARM");
        SPECIAL_PERMISSION_LIST.add("android.permission.MANAGE_EXTERNAL_STORAGE");
        SPECIAL_PERMISSION_LIST.add("android.permission.REQUEST_INSTALL_PACKAGES");
        SPECIAL_PERMISSION_LIST.add("android.permission.PICTURE_IN_PICTURE");
        SPECIAL_PERMISSION_LIST.add("android.permission.SYSTEM_ALERT_WINDOW");
        SPECIAL_PERMISSION_LIST.add("android.permission.WRITE_SETTINGS");
        SPECIAL_PERMISSION_LIST.add("android.permission.ACCESS_NOTIFICATION_POLICY");
        SPECIAL_PERMISSION_LIST.add("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        SPECIAL_PERMISSION_LIST.add("android.permission.PACKAGE_USAGE_STATS");
        SPECIAL_PERMISSION_LIST.add("android.permission.NOTIFICATION_SERVICE");
        SPECIAL_PERMISSION_LIST.add("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        SPECIAL_PERMISSION_LIST.add("android.permission.BIND_VPN_SERVICE");
        PERMISSION_VERSION_MAP.put("android.permission.SCHEDULE_EXACT_ALARM", 31);
        PERMISSION_VERSION_MAP.put("android.permission.MANAGE_EXTERNAL_STORAGE", 30);
        PERMISSION_VERSION_MAP.put("android.permission.REQUEST_INSTALL_PACKAGES", 26);
        PERMISSION_VERSION_MAP.put("android.permission.PICTURE_IN_PICTURE", 26);
        PERMISSION_VERSION_MAP.put("android.permission.SYSTEM_ALERT_WINDOW", 17);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_SETTINGS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_NOTIFICATION_POLICY", 23);
        PERMISSION_VERSION_MAP.put("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.PACKAGE_USAGE_STATS", 21);
        PERMISSION_VERSION_MAP.put("android.permission.NOTIFICATION_SERVICE", 19);
        PERMISSION_VERSION_MAP.put("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE", 18);
        PERMISSION_VERSION_MAP.put("android.permission.BIND_VPN_SERVICE", 14);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_VISUAL_USER_SELECTED", 34);
        PERMISSION_VERSION_MAP.put("android.permission.POST_NOTIFICATIONS", 33);
        PERMISSION_VERSION_MAP.put("android.permission.NEARBY_WIFI_DEVICES", 33);
        PERMISSION_VERSION_MAP.put("android.permission.BODY_SENSORS_BACKGROUND", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_IMAGES", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_VIDEO", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_AUDIO", 33);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_SCAN", 31);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_CONNECT", 31);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_ADVERTISE", 31);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_BACKGROUND_LOCATION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACTIVITY_RECOGNITION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_MEDIA_LOCATION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACCEPT_HANDOVER", 28);
        PERMISSION_VERSION_MAP.put("android.permission.ANSWER_PHONE_CALLS", 26);
        PERMISSION_VERSION_MAP.put("android.permission.READ_PHONE_NUMBERS", 26);
        PERMISSION_VERSION_MAP.put("com.android.permission.GET_INSTALLED_APPS", 17);
        PERMISSION_VERSION_MAP.put("android.permission.READ_EXTERNAL_STORAGE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_EXTERNAL_STORAGE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.CAMERA", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECORD_AUDIO", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_FINE_LOCATION", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_COARSE_LOCATION", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CONTACTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CONTACTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.GET_ACCOUNTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CALENDAR", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CALENDAR", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_PHONE_STATE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.CALL_PHONE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CALL_LOG", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CALL_LOG", 23);
        PERMISSION_VERSION_MAP.put("com.android.voicemail.permission.ADD_VOICEMAIL", 23);
        PERMISSION_VERSION_MAP.put("android.permission.USE_SIP", 23);
        PERMISSION_VERSION_MAP.put("android.permission.PROCESS_OUTGOING_CALLS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.BODY_SENSORS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.SEND_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_WAP_PUSH", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_MMS", 23);
        VIRTUAL_PERMISSION_LIST.add("android.permission.NOTIFICATION_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.BIND_VPN_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.PICTURE_IN_PICTURE");
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.POST_NOTIFICATIONS", new String[]{"android.permission.NOTIFICATION_SERVICE"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.NEARBY_WIFI_DEVICES", new String[]{"android.permission.ACCESS_FINE_LOCATION"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.READ_MEDIA_IMAGES", new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.READ_MEDIA_VIDEO", new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.READ_MEDIA_AUDIO", new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.BLUETOOTH_SCAN", new String[]{"android.permission.ACCESS_FINE_LOCATION"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.MANAGE_EXTERNAL_STORAGE", new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        NEW_AND_OLD_PERMISSION_MAP.put("android.permission.READ_PHONE_NUMBERS", new String[]{"android.permission.READ_PHONE_STATE"});
        BACKGROUND_PERMISSION_MAP.put("android.permission.ACCESS_BACKGROUND_LOCATION", PermissionUtils.asArrayList("android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"));
        BACKGROUND_PERMISSION_MAP.put("android.permission.BODY_SENSORS_BACKGROUND", PermissionUtils.asArrayList("android.permission.BODY_SENSORS"));
        Set<String> backgroundPermissions = BACKGROUND_PERMISSION_MAP.keySet();
        ArrayList<String> storagePermissionGroup = PermissionUtils.asArrayList("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.STORAGE, storagePermissionGroup);
        for (String string : storagePermissionGroup) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.STORAGE);
        }
        ArrayList<String> calendarPermissionGroup = PermissionUtils.asArrayList("android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.CALENDAR, calendarPermissionGroup);
        for (String string : calendarPermissionGroup) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.CALENDAR);
        }
        ArrayList<String> arrayList = PermissionUtils.asArrayList("android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.CONTACTS, arrayList);
        for (String string : arrayList) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.CONTACTS);
        }
        ArrayList<String> arrayList2 = PermissionUtils.asArrayList("android.permission.SEND_SMS", "android.permission.READ_SMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECEIVE_MMS");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.SMS, arrayList2);
        for (String permission5 : arrayList2) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(permission5, PermissionGroupType.SMS);
        }
        ArrayList<String> arrayList3 = PermissionUtils.asArrayList("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_BACKGROUND_LOCATION");
        ArrayList<String> bluetoothPermissions = PermissionUtils.asArrayList("android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE");
        String wifiPermission = "android.permission.NEARBY_WIFI_DEVICES";
        ArrayList<String> nearbyDevicesPermissionGroup = AndroidVersionTools.isAndroid13() ? new ArrayList(bluetoothPermissions.size() + 1) : new ArrayList<String>(bluetoothPermissions.size());
        if (AndroidVersionTools.isAndroid12()) {
            nearbyDevicesPermissionGroup.addAll(bluetoothPermissions);
        } else {
            arrayList3.addAll(bluetoothPermissions);
        }
        if (AndroidVersionTools.isAndroid13()) {
            nearbyDevicesPermissionGroup.add(wifiPermission);
        } else {
            arrayList3.add(wifiPermission);
        }
        if (!nearbyDevicesPermissionGroup.isEmpty()) {
            DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.NEARBY_DEVICES, nearbyDevicesPermissionGroup);
            for (String string : nearbyDevicesPermissionGroup) {
                DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.NEARBY_DEVICES);
            }
        }
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.LOCATION, arrayList3);
        for (String string : arrayList3) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.LOCATION);
        }
        ArrayList<String> sensorsPermissionGroup = PermissionUtils.asArrayList("android.permission.BODY_SENSORS", "android.permission.BODY_SENSORS_BACKGROUND");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.SENSORS, sensorsPermissionGroup);
        for (String permission7 : sensorsPermissionGroup) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(permission7, PermissionGroupType.SENSORS);
        }
        ArrayList<String> arrayList4 = PermissionUtils.asArrayList("android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.READ_PHONE_NUMBERS", "android.permission.ANSWER_PHONE_CALLS", "android.permission.ACCEPT_HANDOVER");
        ArrayList<String> callLogPermissionGroup = PermissionUtils.asArrayList("android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "android.permission.PROCESS_OUTGOING_CALLS");
        if (AndroidVersionTools.isAndroid9()) {
            DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.PHONE, arrayList4);
            for (String string : arrayList4) {
                DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.PHONE);
            }
            DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.CALL_LOG, callLogPermissionGroup);
            for (String string : callLogPermissionGroup) {
                DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(string, PermissionGroupType.CALL_LOG);
            }
        } else {
            ArrayList<String> oldPhonePermissionGroup = new ArrayList<String>();
            oldPhonePermissionGroup.addAll(arrayList4);
            oldPhonePermissionGroup.addAll(callLogPermissionGroup);
            DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.PHONE, oldPhonePermissionGroup);
            for (String permission9 : oldPhonePermissionGroup) {
                DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(permission9, PermissionGroupType.PHONE);
            }
        }
        ArrayList<String> imageAndVideoPermissionGroup = PermissionUtils.asArrayList("android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_VISUAL_USER_SELECTED");
        DANGEROUS_PERMISSION_GROUP_MAP.put(PermissionGroupType.IMAGE_AND_VIDEO_MEDIA, imageAndVideoPermissionGroup);
        for (String permission2 : imageAndVideoPermissionGroup) {
            DANGEROUS_PERMISSION_GROUP_TYPE_MAP.put(permission2, PermissionGroupType.IMAGE_AND_VIDEO_MEDIA);
        }
        LOW_LEVEL_PERMISSION_LIST.addAll(BACKGROUND_PERMISSION_MAP.keySet());
        LOW_LEVEL_PERMISSION_LIST.add("android.permission.ACCESS_MEDIA_LOCATION");
        for (String permission2 : backgroundPermissions) {
            if (AndroidVersionTools.getCurrentAndroidVersionCode() < PermissionHelper.findAndroidVersionByPermission(permission2)) continue;
            PERMISSIONS_REQUEST_INTERVAL_TIME.put(permission2, 150);
        }
        if (AndroidVersionTools.isAndroid11()) {
            int n = 200;
        } else {
            int n = 300;
        }
        if (PhoneRomUtils.isEmui() || PhoneRomUtils.isHarmonyOs()) {
            if (AndroidVersionTools.isAndroid8()) {
                int n = 300;
            } else {
                int n = 500;
            }
        }
        for (String permission10 : SPECIAL_PERMISSION_LIST) {
            void var13_35;
            if (AndroidVersionTools.getCurrentAndroidVersionCode() < PermissionHelper.findAndroidVersionByPermission(permission10)) continue;
            PERMISSIONS_RESULT_WAIT_TIME.put(permission10, (int)var13_35);
        }
        if (PhoneRomUtils.isMiui() && AndroidVersionTools.isAndroid11() && AndroidVersionTools.getCurrentAndroidVersionCode() >= PermissionHelper.findAndroidVersionByPermission("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            PERMISSIONS_RESULT_WAIT_TIME.put("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", 1000);
        }
    }
}

