/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.PermissionFragmentFactory;
import com.hjq.permissions.PermissionFragmentSupport;
import com.hjq.permissions.PermissionFragmentSupportByDangerous;
import com.hjq.permissions.PermissionFragmentSupportBySpecial;
import com.hjq.permissions.PermissionRequestCodeManager;
import com.hjq.permissions.PermissionType;
import java.util.List;

final class PermissionFragmentFactoryBySupport
extends PermissionFragmentFactory<FragmentActivity, FragmentManager> {
    PermissionFragmentFactoryBySupport(@NonNull FragmentActivity activity, @NonNull FragmentManager fragmentManager) {
        super(activity, fragmentManager);
    }

    @Override
    void createAndCommitFragment(@NonNull List<String> permissions, @NonNull PermissionType permissionType, @Nullable OnPermissionFlowCallback callback) {
        int maxRequestCode;
        PermissionFragmentSupport fragment = permissionType == PermissionType.SPECIAL ? new PermissionFragmentSupportBySpecial() : new PermissionFragmentSupportByDangerous();
        if (permissionType == PermissionType.DANGEROUS) {
            try {
                FragmentActivity activity = (FragmentActivity)this.getActivity();
                activity.validateRequestPermissionsRequestCode(65535);
                maxRequestCode = 65535;
            }
            catch (IllegalArgumentException ignore) {
                maxRequestCode = 255;
            }
            catch (Exception ignore) {
                maxRequestCode = 65535;
            }
        } else {
            maxRequestCode = 65535;
        }
        int requestCode = PermissionRequestCodeManager.generateRandomRequestCode(maxRequestCode);
        fragment.setArguments(this.generatePermissionArguments(permissions, requestCode));
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setCallback(callback);
        fragment.commitAttach((FragmentManager)this.getFragmentManager());
    }
}

