/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.PermissionType;
import java.util.ArrayList;
import java.util.List;

public abstract class PermissionFragmentFactory<A extends Activity, F> {
    @NonNull
    private final A mActivity;
    @NonNull
    private final F mFragmentManager;

    PermissionFragmentFactory(@NonNull A activity, @NonNull F fragmentManager) {
        this.mActivity = activity;
        this.mFragmentManager = fragmentManager;
    }

    @NonNull
    A getActivity() {
        return this.mActivity;
    }

    @NonNull
    F getFragmentManager() {
        return this.mFragmentManager;
    }

    abstract void createAndCommitFragment(@NonNull List<String> var1, @NonNull PermissionType var2, @Nullable OnPermissionFlowCallback var3);

    @NonNull
    Bundle generatePermissionArguments(@NonNull List<String> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        Bundle bundle = new Bundle();
        bundle.putInt("request_code", requestCode);
        if (permissions instanceof ArrayList) {
            bundle.putStringArrayList("request_permissions", (ArrayList)permissions);
        } else {
            bundle.putStringArrayList("request_permissions", new ArrayList<String>(permissions));
        }
        return bundle;
    }
}

