/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.PermissionDelegateImplV30;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV31
extends PermissionDelegateImplV30 {
    PermissionDelegateImplV31() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2, boolean skipRequest) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.isGrantedAlarmPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
            if (!AndroidVersionTools.isAndroid12()) {
                return PermissionUtils.isGrantedPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
            if (!AndroidVersionTools.isAndroid12()) {
                return true;
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2, skipRequest);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
            if (!AndroidVersionTools.isAndroid12()) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
            if (!AndroidVersionTools.isAndroid12()) {
                return false;
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION") && AndroidVersionTools.getTargetSdkVersionCode((Context)activity) >= 31) {
            if (!PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION")) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.ACCESS_FINE_LOCATION") && PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.ACCESS_COARSE_LOCATION");
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.getAlarmPermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    private static boolean isGrantedAlarmPermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid12()) {
            return true;
        }
        return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
    }

    private static Intent getAlarmPermissionIntent(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid12()) {
            return PermissionDelegateImplV31.getApplicationDetailsIntent(context);
        }
        Intent intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV31.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

