/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.IStartActivityDelegate;
import com.hjq.permissions.StartActivityDelegateByActivity;
import com.hjq.permissions.StartActivityDelegateByContext;
import com.hjq.permissions.StartActivityDelegateByFragmentApp;
import com.hjq.permissions.StartActivityDelegateByFragmentSupport;

final class PermissionActivityIntentHandler {
    private static final String SUB_INTENT_KEY = "sub_intent_key";

    PermissionActivityIntentHandler() {
    }

    private static Intent findSubIntentBySuperIntent(@NonNull Intent superIntent) {
        Intent subIntent = AndroidVersionTools.isAndroid13() ? (Intent)superIntent.getParcelableExtra(SUB_INTENT_KEY, Intent.class) : (Intent)superIntent.getParcelableExtra(SUB_INTENT_KEY);
        return subIntent;
    }

    private static Intent findDeepIntent(@NonNull Intent intent) {
        Intent subIntent = PermissionActivityIntentHandler.findSubIntentBySuperIntent(intent);
        if (subIntent != null) {
            return PermissionActivityIntentHandler.findDeepIntent(subIntent);
        }
        return intent;
    }

    static Intent addSubIntentForMainIntent(@Nullable Intent mainIntent, @Nullable Intent subIntent) {
        if (mainIntent == null && subIntent != null) {
            return subIntent;
        }
        if (subIntent == null) {
            return mainIntent;
        }
        Intent deepSubIntent = PermissionActivityIntentHandler.findDeepIntent(mainIntent);
        deepSubIntent.putExtra(SUB_INTENT_KEY, (Parcelable)subIntent);
        return mainIntent;
    }

    static boolean startActivity(@NonNull Context context, Intent intent) {
        return PermissionActivityIntentHandler.startActivity(new StartActivityDelegateByContext(context), intent);
    }

    static boolean startActivity(@NonNull Activity activity, Intent intent) {
        return PermissionActivityIntentHandler.startActivity(new StartActivityDelegateByActivity(activity), intent);
    }

    static boolean startActivity(@NonNull Fragment fragment, Intent intent) {
        return PermissionActivityIntentHandler.startActivity(new StartActivityDelegateByFragmentApp(fragment), intent);
    }

    static boolean startActivity(@NonNull android.support.v4.app.Fragment fragment, Intent intent) {
        return PermissionActivityIntentHandler.startActivity(new StartActivityDelegateByFragmentSupport(fragment), intent);
    }

    static boolean startActivity(@NonNull IStartActivityDelegate delegate, @NonNull Intent intent) {
        try {
            delegate.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent subIntent = PermissionActivityIntentHandler.findSubIntentBySuperIntent(intent);
            if (subIntent == null) {
                return false;
            }
            return PermissionActivityIntentHandler.startActivity(delegate, subIntent);
        }
    }

    static boolean startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode) {
        return PermissionActivityIntentHandler.startActivityForResult(new StartActivityDelegateByActivity(activity), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode) {
        return PermissionActivityIntentHandler.startActivityForResult(new StartActivityDelegateByFragmentApp(fragment), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull android.support.v4.app.Fragment fragment, @NonNull Intent intent, int requestCode) {
        return PermissionActivityIntentHandler.startActivityForResult(new StartActivityDelegateByFragmentSupport(fragment), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull IStartActivityDelegate delegate, @NonNull Intent intent, int requestCode) {
        try {
            delegate.startActivityForResult(intent, requestCode);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent subIntent = PermissionActivityIntentHandler.findSubIntentBySuperIntent(intent);
            if (subIntent == null) {
                return false;
            }
            return PermissionActivityIntentHandler.startActivityForResult(delegate, subIntent, requestCode);
        }
    }
}

