/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.PermissionFragmentFactory;
import com.hjq.permissions.RequestPermissionLogicPresenter;
import java.util.List;

public interface OnPermissionInterceptor {
    default public void launchPermissionRequest(@NonNull Activity activity, @NonNull List<String> requestPermissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, @NonNull OnPermissionDescription permissionDescription, @Nullable OnPermissionCallback callback) {
        this.dispatchPermissionRequest(activity, requestPermissions, fragmentFactory, permissionDescription, callback);
    }

    default public void grantedPermissionRequest(@NonNull Activity activity, @NonNull List<String> requestPermissions, @NonNull List<String> grantedPermissions, boolean allGranted, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onGranted(grantedPermissions, allGranted);
    }

    default public void deniedPermissionRequest(@NonNull Activity activity, @NonNull List<String> requestPermissions, @NonNull List<String> deniedPermissions, boolean doNotAskAgain, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onDenied(deniedPermissions, doNotAskAgain);
    }

    default public void finishPermissionRequest(@NonNull Activity activity, @NonNull List<String> requestPermissions, boolean skipRequest, @Nullable OnPermissionCallback callback) {
    }

    default public void dispatchPermissionRequest(@NonNull Activity activity, @NonNull List<String> requestPermissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, @NonNull OnPermissionDescription permissionDescription, @Nullable OnPermissionCallback callback) {
        new RequestPermissionLogicPresenter(activity, requestPermissions, fragmentFactory, this, permissionDescription, callback).request();
    }
}

