/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV30;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV31
extends PermissionDelegateImplV30 {
    PermissionDelegateImplV31() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            if (!AndroidVersion.isAndroid12()) {
                return true;
            }
            return PermissionDelegateImplV31.isGrantedAlarmPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid12()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE"}, permission2)) {
            if (!AndroidVersion.isAndroid12()) {
                return true;
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid12()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE"}, permission2)) {
            if (!AndroidVersion.isAndroid12()) {
                return false;
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION") && AndroidVersion.isAndroid6() && AndroidVersion.getTargetSdkVersionCode((Context)activity) >= 31) {
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_COARSE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            if (!AndroidVersion.isAndroid12()) {
                return PermissionDelegateImplV31.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV31.getAlarmPermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    @RequiresApi(value=31)
    private static boolean isGrantedAlarmPermission(@NonNull Context context) {
        return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
    }

    @RequiresApi(value=31)
    private static Intent getAlarmPermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV31.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

