/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV28;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV29
extends PermissionDelegateImplV28 {
    PermissionDelegateImplV29() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid10()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return this.isGrantedReadStoragePermission(context) && PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_MEDIA_LOCATION");
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid10()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            if (!AndroidVersion.isAndroid10()) {
                return true;
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid10()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid10()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return this.isGrantedReadStoragePermission((Context)activity) && !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            if (!AndroidVersion.isAndroid10()) {
                return false;
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @RequiresApi(value=23)
    private boolean isGrantedReadStoragePermission(@NonNull Context context) {
        if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            return PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_IMAGES") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
        }
        if (AndroidVersion.isAndroid11() && AndroidVersion.getTargetSdkVersionCode(context) >= 30) {
            return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
        }
        return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
    }
}

