/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.GetInstalledAppsPermissionCompat;
import com.hjq.permissions.PermissionDelegateImplV21;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import com.hjq.permissions.WindowPermissionCompat;

class PermissionDelegateImplV23
extends PermissionDelegateImplV21 {
    PermissionDelegateImplV23() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission) {
        if (!PermissionHelper.isSpecialPermission(permission)) {
            if (PermissionUtils.equalsPermission(permission, "com.android.permission.GET_INSTALLED_APPS")) {
                return GetInstalledAppsPermissionCompat.isGrantedPermission(context);
            }
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            return PermissionUtils.checkSelfPermission(context, permission);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.isGrantedPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_SETTINGS")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            return PermissionDelegateImplV23.isGrantedSettingPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            return PermissionDelegateImplV23.isGrantedNotDisturbPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            return PermissionDelegateImplV23.isGrantedIgnoreBatteryPermission(context);
        }
        return super.isGrantedPermission(context, permission);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission) {
        if (!PermissionHelper.isSpecialPermission(permission)) {
            if (PermissionUtils.equalsPermission(permission, "com.android.permission.GET_INSTALLED_APPS")) {
                return GetInstalledAppsPermissionCompat.isDoNotAskAgainPermission(activity);
            }
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.SYSTEM_ALERT_WINDOW", "android.permission.WRITE_SETTINGS", "android.permission.ACCESS_NOTIFICATION_POLICY", "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS"}, permission)) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission);
    }

    @Override
    public boolean recheckPermissionResult(@NonNull Context context, @NonNull String permission, boolean grantResult) {
        if (PermissionUtils.equalsPermission(permission, "com.android.permission.GET_INSTALLED_APPS")) {
            return this.isGrantedPermission(context, permission);
        }
        return super.recheckPermissionResult(context, permission, grantResult);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission) {
        if (PermissionUtils.equalsPermission(permission, "com.android.permission.GET_INSTALLED_APPS")) {
            return GetInstalledAppsPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_SETTINGS")) {
            if (!AndroidVersion.isAndroid6()) {
                return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV23.getSettingPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
            if (!AndroidVersion.isAndroid6()) {
                return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV23.getNotDisturbPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            if (!AndroidVersion.isAndroid6()) {
                return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV23.getIgnoreBatteryPermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission);
    }

    @RequiresApi(value=23)
    private static boolean isGrantedSettingPermission(@NonNull Context context) {
        return Settings.System.canWrite((Context)context);
    }

    @RequiresApi(value=23)
    private static Intent getSettingPermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    @RequiresApi(value=23)
    private static boolean isGrantedNotDisturbPermission(@NonNull Context context) {
        return ((NotificationManager)context.getSystemService(NotificationManager.class)).isNotificationPolicyAccessGranted();
    }

    @RequiresApi(value=23)
    private static Intent getNotDisturbPermissionIntent(@NonNull Context context) {
        Intent intent;
        if (AndroidVersion.isAndroid10()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_DETAIL_SETTINGS");
            intent.setData(PermissionUtils.getPackageNameUri(context));
            if (PhoneRomUtils.isHarmonyOs() || PhoneRomUtils.isMagicOs()) {
                intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
            }
        } else {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    @RequiresApi(value=23)
    private static boolean isGrantedIgnoreBatteryPermission(@NonNull Context context) {
        return ((PowerManager)context.getSystemService(PowerManager.class)).isIgnoringBatteryOptimizations(context.getPackageName());
    }

    @RequiresApi(value=23)
    private static Intent getIgnoreBatteryPermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

