/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import java.util.Collections;

class PermissionDelegateImplBase
implements PermissionDelegate {
    PermissionDelegateImplBase() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImplBase.isGrantedVpnPermission(context);
        }
        return true;
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return false;
        }
        return false;
    }

    @Override
    public boolean recheckPermissionResult(@NonNull Context context, @NonNull String permission2, boolean grantResult) {
        if (PermissionApi.isSpecialPermission(permission2)) {
            return this.isGrantedPermission(context, permission2);
        }
        if (PermissionHelper.findAndroidVersionByPermission(permission2) > AndroidVersion.getAndroidVersionCode()) {
            return this.isGrantedPermission(context, permission2);
        }
        return grantResult;
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImplBase.getVpnPermissionIntent(context);
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context, Collections.singletonList(permission2));
    }

    private static boolean isGrantedVpnPermission(@NonNull Context context) {
        return VpnService.prepare((Context)context) == null;
    }

    private static Intent getVpnPermissionIntent(@NonNull Context context) {
        Intent intent = VpnService.prepare((Context)context);
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getApplicationDetailsIntent(@NonNull Context context) {
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }
}

