/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.util.Log;
import com.hjq.toast.ToastParams;
import com.hjq.toast.Toaster;
import com.hjq.toast.config.IToastInterceptor;
import java.lang.reflect.Modifier;

public class ToastLogInterceptor
implements IToastInterceptor {
    @Override
    public boolean intercept(ToastParams params) {
        this.printToast(params.text);
        return false;
    }

    protected void printToast(CharSequence text) {
        StackTraceElement[] stackTraces;
        if (!this.isLogEnable()) {
            return;
        }
        for (StackTraceElement stackTrace : stackTraces = new Throwable().getStackTrace()) {
            int lineNumber = stackTrace.getLineNumber();
            if (lineNumber <= 0) continue;
            String className = stackTrace.getClassName();
            try {
                Class<?> clazz = Class.forName(className);
                if (this.filterClass(clazz)) continue;
                this.printLog("(" + stackTrace.getFileName() + ":" + lineNumber + ") " + text.toString());
                break;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isLogEnable() {
        return Toaster.isDebugMode();
    }

    protected void printLog(String msg) {
        Log.i((String)"Toaster", (String)msg);
    }

    protected boolean filterClass(Class<?> clazz) {
        return IToastInterceptor.class.isAssignableFrom(clazz) || Toaster.class.equals(clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers());
    }
}

