/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import com.hjq.toast.ActivityStack;
import com.hjq.toast.ActivityToast;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SystemToast;
import com.hjq.toast.config.IToast;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import java.lang.ref.SoftReference;

public class ToastStrategy
extends Handler
implements IToastStrategy {
    private static final int DELAY_TIMEOUT = 200;
    private static final int TYPE_SHOW = 1;
    private static final int TYPE_CANCEL = 2;
    private Application mApplication;
    private ActivityStack mActivityStack;
    private SoftReference<IToast> mToastReference;
    private IToastStyle<?> mToastStyle;

    public ToastStrategy() {
        super(Looper.getMainLooper());
    }

    @Override
    public void registerStrategy(Application application) {
        this.mApplication = application;
        this.mActivityStack = ActivityStack.register(application);
    }

    @Override
    public void bindStyle(IToastStyle<?> style) {
        this.mToastStyle = style;
    }

    @Override
    public IToast createToast(Application application) {
        Activity resumedActivity = this.mActivityStack.getForegroundActivity();
        IToast toast = resumedActivity != null ? new ActivityToast(resumedActivity) : (Build.VERSION.SDK_INT == 25 ? new SafeToast(application) : new SystemToast(application));
        if (toast instanceof ActivityToast || Build.VERSION.SDK_INT < 30 || application.getApplicationInfo().targetSdkVersion < 30) {
            toast.setView((View)this.mToastStyle.createView((Context)application));
            toast.setGravity(this.mToastStyle.getGravity(), this.mToastStyle.getXOffset(), this.mToastStyle.getYOffset());
            toast.setMargin(this.mToastStyle.getHorizontalMargin(), this.mToastStyle.getVerticalMargin());
        }
        return toast;
    }

    @Override
    public void showToast(CharSequence text) {
        this.removeMessages(1);
        Message msg = Message.obtain();
        msg.what = 1;
        msg.obj = text;
        this.sendMessageDelayed(msg, 200L);
    }

    @Override
    public void cancelToast() {
        this.removeMessages(2);
        this.sendEmptyMessage(2);
    }

    public void handleMessage(Message msg) {
        IToast toast = null;
        if (this.mToastReference != null) {
            toast = this.mToastReference.get();
        }
        switch (msg.what) {
            case 1: {
                if (!(msg.obj instanceof CharSequence)) break;
                CharSequence text = (CharSequence)msg.obj;
                if (toast != null) {
                    toast.cancel();
                }
                toast = this.createToast(this.mApplication);
                this.mToastReference = new SoftReference<IToast>(toast);
                toast.setDuration(this.getToastDuration(text));
                toast.setText(text);
                toast.show();
                break;
            }
            case 2: {
                if (toast == null) break;
                toast.cancel();
                break;
            }
        }
    }

    protected int getToastDuration(CharSequence text) {
        return text.length() > 20 ? 1 : 0;
    }
}

