/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.hjq.toast.ToastHelper;

@TargetApi(value=19)
final class WindowHelper
implements Application.ActivityLifecycleCallbacks {
    private Activity mTopActivity;
    private final ToastHelper mToastHelper;

    private WindowHelper(ToastHelper toast) {
        this.mToastHelper = toast;
    }

    static WindowHelper register(ToastHelper toast, Application application) {
        WindowHelper window = new WindowHelper(toast);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)window);
        return window;
    }

    Activity getTopActivity() {
        return this.mTopActivity;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mTopActivity = activity;
    }

    public void onActivityStarted(Activity activity) {
        this.mTopActivity = activity;
    }

    public void onActivityResumed(Activity activity) {
        this.mTopActivity = activity;
    }

    public void onActivityPaused(Activity activity) {
        if (this.mToastHelper.isShow()) {
            this.mToastHelper.cancel();
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.mTopActivity == activity) {
            this.mTopActivity = null;
        }
    }
}

