/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.IToastInterceptor;
import com.hjq.toast.IToastStrategy;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.ToastInterceptor;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.style.ToastBlackStyle;

public final class ToastUtils {
    private static IToastInterceptor sInterceptor;
    private static IToastStrategy sStrategy;
    private static Toast sToast;

    private ToastUtils() {
    }

    public static void init(Application application) {
        ToastUtils.init(application, new ToastBlackStyle((Context)application));
    }

    public static void init(Application application, IToastStyle style2) {
        ToastUtils.checkNullPointer(application);
        if (sInterceptor == null) {
            ToastUtils.setToastInterceptor(new ToastInterceptor());
        }
        if (sStrategy == null) {
            ToastUtils.setToastStrategy(new ToastStrategy());
        }
        ToastUtils.setToast(sStrategy.create(application));
        ToastUtils.setView((View)ToastUtils.createTextView((Context)application, style2));
        ToastUtils.setGravity(style2.getGravity(), style2.getXOffset(), style2.getYOffset());
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void show(int id2) {
        ToastUtils.checkToastState();
        try {
            ToastUtils.show(ToastUtils.getContext().getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static synchronized void show(CharSequence text) {
        ToastUtils.checkToastState();
        if (sInterceptor.intercept(sToast, text)) {
            return;
        }
        sStrategy.show(text);
    }

    public static synchronized void cancel() {
        ToastUtils.checkToastState();
        sStrategy.cancel();
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.checkToastState();
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)ToastUtils.getContext().getResources().getConfiguration().getLayoutDirection());
        }
        sToast.setGravity(gravity, xOffset, yOffset);
    }

    public static void setView(int id2) {
        ToastUtils.checkToastState();
        ToastUtils.setView(View.inflate((Context)ToastUtils.getContext(), (int)id2, null));
    }

    public static void setView(View view) {
        ToastUtils.checkToastState();
        ToastUtils.checkNullPointer(view);
        Context context = view.getContext();
        if (context instanceof Activity || context instanceof Service) {
            throw new IllegalArgumentException("The view must be initialized using the context of the application");
        }
        if (sToast != null) {
            sToast.cancel();
            sToast.setView(view);
        }
    }

    public static <V extends View> V getView() {
        ToastUtils.checkToastState();
        return (V)sToast.getView();
    }

    public static void initStyle(IToastStyle style2) {
        ToastUtils.checkNullPointer(style2);
        if (sToast != null) {
            sToast.cancel();
            sToast.setView((View)ToastUtils.createTextView(ToastUtils.getContext(), style2));
            sToast.setGravity(style2.getGravity(), style2.getXOffset(), style2.getYOffset());
        }
    }

    public static void setToast(Toast toast) {
        ToastUtils.checkNullPointer(toast);
        if (sToast != null && toast.getView() == null) {
            toast.setView(sToast.getView());
            toast.setGravity(sToast.getGravity(), sToast.getXOffset(), sToast.getYOffset());
            toast.setMargin(sToast.getHorizontalMargin(), sToast.getVerticalMargin());
        }
        sToast = toast;
        if (sStrategy != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastStrategy(IToastStrategy strategy) {
        ToastUtils.checkNullPointer(strategy);
        sStrategy = strategy;
        if (sToast != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastInterceptor(IToastInterceptor interceptor) {
        ToastUtils.checkNullPointer(interceptor);
        sInterceptor = interceptor;
    }

    public static Toast getToast() {
        return sToast;
    }

    private static void checkToastState() {
        if (sToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
    }

    private static void checkNullPointer(Object object) {
        if (object == null) {
            throw new NullPointerException("are you ok?");
        }
    }

    private static TextView createTextView(Context context, IToastStyle style2) {
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setTextColor(style2.getTextColor());
        textView.setTextSize(0, style2.getTextSize());
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setPaddingRelative(style2.getPaddingStart(), style2.getPaddingTop(), style2.getPaddingEnd(), style2.getPaddingBottom());
        } else {
            textView.setPadding(style2.getPaddingStart(), style2.getPaddingTop(), style2.getPaddingEnd(), style2.getPaddingBottom());
        }
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(style2.getBackgroundColor());
        drawable.setCornerRadius((float)style2.getCornerRadius());
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground((Drawable)drawable);
        } else {
            textView.setBackgroundDrawable((Drawable)drawable);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ((float)style2.getZ());
        }
        if (style2.getMaxLines() > 0) {
            textView.setMaxLines(style2.getMaxLines());
        }
        return textView;
    }

    private static Context getContext() {
        ToastUtils.checkToastState();
        return sToast.getView().getContext();
    }
}

