/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

public class BaseToast
extends Toast {
    private TextView mMessageView;

    public BaseToast(Application application) {
        super((Context)application);
    }

    public void setView(View view) {
        super.setView(view);
        this.setMessageView(BaseToast.findMessageView(view));
    }

    public void setText(CharSequence s) {
        this.mMessageView.setText(s);
    }

    void setMessageView(TextView textView) {
        this.mMessageView = textView;
    }

    static TextView findMessageView(View view) {
        TextView textView;
        if (view instanceof TextView) {
            return (TextView)view;
        }
        if (view.findViewById(16908299) instanceof TextView) {
            return (TextView)view.findViewById(16908299);
        }
        if (view instanceof ViewGroup && (textView = BaseToast.findTextView((ViewGroup)view)) != null) {
            return textView;
        }
        throw new IllegalArgumentException("The layout must contain a TextView");
    }

    private static TextView findTextView(ViewGroup group) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            TextView textView;
            View view = group.getChildAt(i);
            if (view instanceof TextView) {
                return (TextView)view;
            }
            if (!(view instanceof ViewGroup) || (textView = BaseToast.findTextView((ViewGroup)view)) == null) continue;
            return textView;
        }
        return null;
    }
}

