/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;
import com.hjq.toast.IToastStrategy;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class ToastStrategy
extends Handler
implements IToastStrategy {
    private static final int DELAY_TIMEOUT = 300;
    private static final int TYPE_SHOW = 1;
    private static final int TYPE_CONTINUE = 2;
    private static final int TYPE_CANCEL = 3;
    private static final int MAX_TOAST_CAPACITY = 3;
    private volatile Queue<CharSequence> mQueue = this.getToastQueue();
    private volatile boolean isShow;
    private Toast mToast;

    public ToastStrategy() {
        super(Looper.getMainLooper());
    }

    @Override
    public void bind(Toast toast) {
        this.mToast = toast;
    }

    @Override
    public void show(CharSequence text) {
        if (!(!this.mQueue.isEmpty() && this.mQueue.contains(text) || this.mQueue.offer(text))) {
            this.mQueue.poll();
            this.mQueue.offer(text);
        }
        if (!this.isShow) {
            this.isShow = true;
            this.sendEmptyMessageDelayed(1, 300L);
        }
    }

    @Override
    public void cancel() {
        if (this.isShow) {
            this.isShow = false;
            this.sendEmptyMessage(3);
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                CharSequence text = this.mQueue.peek();
                if (text != null) {
                    this.mToast.setText(text);
                    this.mToast.show();
                    this.sendEmptyMessageDelayed(2, this.getToastDuration(text) + 300);
                    break;
                }
                this.isShow = false;
                break;
            }
            case 2: {
                this.mQueue.poll();
                if (!this.mQueue.isEmpty()) {
                    this.sendEmptyMessage(1);
                    break;
                }
                this.isShow = false;
                break;
            }
            case 3: {
                this.isShow = false;
                this.mQueue.clear();
                this.mToast.cancel();
                break;
            }
        }
    }

    public Queue<CharSequence> getToastQueue() {
        return new ArrayBlockingQueue<CharSequence>(3);
    }

    public int getToastDuration(CharSequence text) {
        return text.length() > 20 ? 3500 : 2000;
    }
}

