/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.ArrayMap;
import android.view.WindowManager;
import com.hjq.toast.ToastHelper;

@TargetApi(value=19)
final class WindowHelper
implements Application.ActivityLifecycleCallbacks {
    private final ArrayMap<String, Activity> mActivitySet = new ArrayMap();
    private final ToastHelper mToastHelper;
    private String mCurrentTag;

    WindowHelper(ToastHelper helper, Application application) {
        this.mToastHelper = helper;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    WindowManager getWindowManager() throws NullPointerException {
        Activity activity;
        if (this.mCurrentTag != null && (activity = (Activity)this.mActivitySet.get((Object)this.mCurrentTag)) != null) {
            return WindowHelper.getWindowManagerObject(activity);
        }
        throw new NullPointerException();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mCurrentTag = WindowHelper.getObjectTag(activity);
        this.mActivitySet.put((Object)this.mCurrentTag, (Object)activity);
    }

    public void onActivityStarted(Activity activity) {
        this.mCurrentTag = WindowHelper.getObjectTag(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.mCurrentTag = WindowHelper.getObjectTag(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.mToastHelper.cancel();
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivitySet.remove((Object)WindowHelper.getObjectTag(activity));
        if (WindowHelper.getObjectTag(activity).equals(this.mCurrentTag)) {
            this.mCurrentTag = null;
        }
    }

    private static String getObjectTag(Object object) {
        return object.getClass().getName() + Integer.toHexString(object.hashCode());
    }

    private static WindowManager getWindowManagerObject(Activity activity) {
        return (WindowManager)activity.getSystemService("window");
    }
}

