/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

class BaseToast
extends Toast {
    private TextView mMessageView;

    BaseToast(Application application) {
        super((Context)application);
    }

    public void setView(View view) {
        super.setView(view);
        this.mMessageView = BaseToast.getMessageView(view);
    }

    public void setText(CharSequence s) {
        this.mMessageView.setText(s);
    }

    private static TextView getMessageView(View view) {
        TextView messageView;
        if (view instanceof TextView) {
            TextView messageView2 = (TextView)view;
            return messageView2;
        }
        if (view.findViewById(16908299) instanceof TextView) {
            TextView messageView3 = (TextView)view.findViewById(16908299);
            return messageView3;
        }
        if (view instanceof ViewGroup && (messageView = BaseToast.findTextView((ViewGroup)view)) != null) {
            return messageView;
        }
        throw new IllegalArgumentException("The layout must contain a TextView");
    }

    private static TextView findTextView(ViewGroup group) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            TextView textView;
            View view = group.getChildAt(i);
            if (view instanceof TextView) {
                return (TextView)view;
            }
            if (!(view instanceof ViewGroup) || (textView = BaseToast.findTextView((ViewGroup)view)) == null) continue;
            return textView;
        }
        return null;
    }
}

